/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.world.FeatureMineralVein;
import blusunrize.immersiveengineering.common.world.IECountPlacement;
import blusunrize.immersiveengineering.common.world.IEHeightProvider;
import blusunrize.immersiveengineering.common.world.IEOreFeature;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class IEWorldGen {
    public static Map<String, PlacedFeature> features = new HashMap<String, PlacedFeature>();
    public static Map<String, Pair<IEServerConfig.Ores.VeinType, List<OreConfiguration.TargetBlockState>>> retroFeatures = new HashMap<String, Pair<IEServerConfig.Ores.VeinType, List<OreConfiguration.TargetBlockState>>>();
    public static boolean anyRetrogenEnabled = false;
    public static final Map<ResourceKey<Level>, List<ChunkPos>> retrogenChunks = new HashMap<ResourceKey<Level>, List<ChunkPos>>();
    int indexToRemove = 0;
    private static final DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"immersiveengineering");
    private static final RegistryObject<FeatureMineralVein> MINERAL_VEIN_FEATURE = FEATURE_REGISTER.register("mineral_vein", FeatureMineralVein::new);
    private static final RegistryObject<IEOreFeature> IE_CONFIG_ORE = FEATURE_REGISTER.register("ie_ore", IEOreFeature::new);
    public static final PlacementModifierType<IECountPlacement> IE_COUNT_PLACEMENT = IEWorldGen.registerPlacement("ie_count", IECountPlacement.CODEC);
    public static final HeightProviderType<IEHeightProvider> IE_HEIGHT_PROVIDER = IEWorldGen.registerHeightProvider("ie_range", IEHeightProvider.CODEC);

    public static void addOreGen(IEServerConfig.Ores.VeinType type) {
        EnumMetals metal = type.metal;
        ImmutableList targetList = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)IEBlocks.Metals.ORES.get((Object)metal).defaultBlockState()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)IEBlocks.Metals.DEEPSLATE_ORES.get((Object)metal).defaultBlockState()));
        IEOreFeature.IEOreFeatureConfig cfg = new IEOreFeature.IEOreFeatureConfig((List<OreConfiguration.TargetBlockState>)targetList, type);
        String name = type.getVeinName();
        PlacedFeature feature = IEWorldGen.register(ImmersiveEngineering.rl(name), ((IEOreFeature)IE_CONFIG_ORE.get()).m_65815_(cfg).m_190821_(IEWorldGen.getOreModifiers(type)));
        features.put(name, feature);
        retroFeatures.put(name, (Pair<IEServerConfig.Ores.VeinType, List<OreConfiguration.TargetBlockState>>)Pair.of((Object)((Object)type), (Object)targetList));
    }

    public static void registerMineralVeinGen() {
        PlacedFeature veinFeature = IEWorldGen.register(ImmersiveEngineering.rl("mineral_veins"), ((FeatureMineralVein)MINERAL_VEIN_FEATURE.get()).m_65815_((FeatureConfiguration)new NoneFeatureConfiguration()).m_190823_(new PlacementModifier[0]));
        features.put("veins", veinFeature);
    }

    public static void onConfigUpdated() {
        anyRetrogenEnabled = false;
        for (Pair<IEServerConfig.Ores.VeinType, List<OreConfiguration.TargetBlockState>> config : retroFeatures.values()) {
            anyRetrogenEnabled |= ((Boolean)IEServerConfig.ORES.ores.get((Object)config.getFirst()).retrogenEnabled.get()).booleanValue();
        }
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent ev) {
        BiomeGenerationSettingsBuilder generation = ev.getGeneration();
        for (Map.Entry<String, PlacedFeature> e : features.entrySet()) {
            generation.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, e.getValue());
        }
    }

    private void generateOres(Random random, int chunkX, int chunkZ, ServerLevel world) {
        for (Map.Entry<String, Pair<IEServerConfig.Ores.VeinType, List<OreConfiguration.TargetBlockState>>> gen : retroFeatures.entrySet()) {
            IEServerConfig.Ores.VeinType type = (IEServerConfig.Ores.VeinType)((Object)gen.getValue().getFirst());
            List targetList = (List)gen.getValue().getSecond();
            IEServerConfig.Ores.OreConfig config = IEServerConfig.ORES.ores.get((Object)type);
            if (!((Boolean)config.retrogenEnabled.get()).booleanValue()) continue;
            PlacedFeature retroFeature = IEContent.ORE_RETROGEN.m_65815_((FeatureConfiguration)new OreConfiguration(targetList, ((Integer)config.veinSize.get()).intValue())).m_190821_(IEWorldGen.getOreModifiers(type));
            retroFeature.m_191782_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, new BlockPos(16 * chunkX, 0, 16 * chunkZ));
        }
    }

    private static List<PlacementModifier> getOreModifiers(IEServerConfig.Ores.VeinType type) {
        return ImmutableList.of((Object)HeightRangePlacement.m_191683_((HeightProvider)new IEHeightProvider(type)), (Object)InSquarePlacement.m_191715_(), (Object)((Object)new IECountPlacement(type)));
    }

    @SubscribeEvent
    public void chunkDataSave(ChunkDataEvent.Save event) {
        CompoundTag levelTag = event.getData().m_128469_("Level");
        CompoundTag nbt = new CompoundTag();
        levelTag.m_128365_("ImmersiveEngineering", (Tag)nbt);
        nbt.m_128379_(IEServerConfig.ORES.retrogen_key.get(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void chunkDataLoad(ChunkDataEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (event.getChunk().m_6415_() == ChunkStatus.f_62326_ && world instanceof Level && !event.getData().m_128469_("ImmersiveEngineering").m_128441_(IEServerConfig.ORES.retrogen_key.get()) && anyRetrogenEnabled) {
            if (((Boolean)IEServerConfig.ORES.retrogen_log_flagChunk.get()).booleanValue()) {
                IELogger.info("Chunk " + event.getChunk().m_7697_() + " has been flagged for Ore RetroGeneration by IE.");
            }
            ResourceKey dimension = ((Level)world).m_46472_();
            Map<ResourceKey<Level>, List<ChunkPos>> map = retrogenChunks;
            synchronized (map) {
                retrogenChunks.computeIfAbsent((ResourceKey<Level>)dimension, d -> new ArrayList()).add(event.getChunk().m_7697_());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        int remaining;
        if (event.side == LogicalSide.CLIENT || event.phase == TickEvent.Phase.START || !(event.world instanceof ServerLevel)) {
            return;
        }
        ResourceKey dimension = event.world.m_46472_();
        int counter = 0;
        Map<ResourceKey<Level>, List<ChunkPos>> map = retrogenChunks;
        synchronized (map) {
            List<ChunkPos> chunks = retrogenChunks.get(dimension);
            if (chunks != null && chunks.size() > 0) {
                if (this.indexToRemove >= chunks.size()) {
                    this.indexToRemove = 0;
                }
                for (int i = 0; i < 2 && this.indexToRemove < chunks.size() && chunks.size() > 0; ++i) {
                    ChunkPos loc = chunks.get(this.indexToRemove);
                    if (event.world.m_7232_(loc.f_45578_, loc.f_45579_)) {
                        long worldSeed = ((WorldGenLevel)event.world).m_7328_();
                        Random fmlRandom = new Random(worldSeed);
                        long xSeed = fmlRandom.nextLong() >> 3;
                        long zSeed = fmlRandom.nextLong() >> 3;
                        fmlRandom.setSeed(xSeed * (long)loc.f_45578_ + zSeed * (long)loc.f_45579_ ^ worldSeed);
                        this.generateOres(fmlRandom, loc.f_45578_, loc.f_45579_, (ServerLevel)event.world);
                        ++counter;
                        chunks.remove(this.indexToRemove);
                        continue;
                    }
                    ++this.indexToRemove;
                }
            }
            remaining = chunks == null ? 0 : chunks.size();
        }
        if (counter > 0 && ((Boolean)IEServerConfig.ORES.retrogen_log_remaining.get()).booleanValue()) {
            IELogger.info("Retrogen was performed on " + counter + " Chunks, " + remaining + " chunks remaining");
        }
    }

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FEATURE_REGISTER.register(bus);
    }

    private static <P extends PlacementModifier> PlacementModifierType<P> registerPlacement(String name, Codec<P> codec) {
        return (PlacementModifierType)Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)ImmersiveEngineering.rl(name), () -> codec);
    }

    private static <P extends HeightProvider> HeightProviderType<P> registerHeightProvider(String name, Codec<P> codec) {
        return (HeightProviderType)Registry.m_122965_((Registry)Registry.f_175419_, (ResourceLocation)ImmersiveEngineering.rl(name), () -> codec);
    }

    private static PlacedFeature register(ResourceLocation key, PlacedFeature placedFeature) {
        return (PlacedFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)key, (Object)placedFeature);
    }
}

