/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IConnectionTemplate;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.NetHandlerCapability;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class WireTemplateHelper {
    private static final String CONNECTIONS_KEY = "immersiveengineering:connections";

    public static void fillConnectionsInArea(Level worldIn, BlockPos startPos, Vec3i size, IConnectionTemplate template) {
        template.getStoredConnections().clear();
        GlobalWireNetwork net = WireTemplateHelper.getNetwork(worldIn);
        if (net == null) {
            return;
        }
        BlockPos endPos = startPos.m_141952_(size).m_142082_(-1, -1, -1);
        BoundingBox box = BoundingBox.m_162375_((Vec3i)startPos, (Vec3i)endPos);
        Vec3i offset = new Vec3i(box.m_162395_(), box.m_162396_(), box.m_162398_());
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos)) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (!(te instanceof IImmersiveConnectable)) continue;
            for (ConnectionPoint cp : ((IImmersiveConnectable)te).getConnectionPoints()) {
                for (Connection conn : net.getLocalNet(cp).getConnections(cp)) {
                    ConnectionPoint otherEnd;
                    if (conn.isInternal() || (otherEnd = conn.getOtherEnd(cp)).compareTo(cp) < 0 || !box.m_71051_((Vec3i)otherEnd.getPosition())) continue;
                    template.getStoredConnections().add(new IConnectionTemplate.TemplateConnection(new ConnectionPoint(pos.m_141950_(offset), cp.getIndex()), new ConnectionPoint(otherEnd.getPosition().m_141950_(offset), otherEnd.getIndex()), conn.type));
                }
            }
        }
    }

    public static void addConnectionsFromTemplate(ServerLevelAccessor iworld, IConnectionTemplate template, StructurePlaceSettings orientation, BlockPos startPos) {
        if (template.getStoredConnections().isEmpty()) {
            return;
        }
        ServerLevel world = iworld.m_6018_();
        GlobalWireNetwork net = WireTemplateHelper.getNetwork((Level)world);
        if (net == null) {
            return;
        }
        for (IConnectionTemplate.TemplateConnection relative : template.getStoredConnections()) {
            ConnectionPoint endA = WireTemplateHelper.getAbsolutePoint(relative.endA(), orientation, (Level)world, startPos);
            ConnectionPoint endB = WireTemplateHelper.getAbsolutePoint(relative.endB(), orientation, (Level)world, startPos);
            if (endA == null || endB == null) continue;
            net.addConnection(new Connection(relative.type(), endA, endB, net));
        }
    }

    public static void addConnectionsToNBT(IConnectionTemplate template, CompoundTag out) {
        if (template.getStoredConnections().isEmpty()) {
            return;
        }
        ListTag connectionsNBT = new ListTag();
        for (IConnectionTemplate.TemplateConnection c : template.getStoredConnections()) {
            connectionsNBT.add((Object)c.toNBT());
        }
        out.m_128365_(CONNECTIONS_KEY, (Tag)connectionsNBT);
    }

    public static void readConnectionsFromNBT(CompoundTag compound, IConnectionTemplate template) {
        ListTag connectionsNBT = compound.m_128437_(CONNECTIONS_KEY, 10);
        template.getStoredConnections().clear();
        for (int i = 0; i < connectionsNBT.size(); ++i) {
            template.getStoredConnections().add(new IConnectionTemplate.TemplateConnection(connectionsNBT.m_128728_(i)));
        }
    }

    @Nullable
    private static ConnectionPoint getAbsolutePoint(ConnectionPoint relative, StructurePlaceSettings orientation, Level world, BlockPos base) {
        BlockPos absolutePos = StructureTemplate.m_74563_((StructurePlaceSettings)orientation, (BlockPos)relative.getPosition()).m_141952_((Vec3i)base);
        BlockEntity connector = world.m_7702_(absolutePos);
        if (!(connector instanceof IImmersiveConnectable)) {
            return null;
        }
        ConnectionPoint point = new ConnectionPoint(absolutePos, relative.getIndex());
        if (!((IImmersiveConnectable)connector).getConnectionPoints().contains(point)) {
            return null;
        }
        return point;
    }

    @Nullable
    private static GlobalWireNetwork getNetwork(Level world) {
        return world.getCapability(NetHandlerCapability.NET_CAPABILITY).resolve().orElse(null);
    }
}

