/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IWireSyncManager;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class WireSyncManager
implements IWireSyncManager {
    private static final SetMultimap<UUID, ChunkPos> wireWatchedChunksByPlayer = HashMultimap.create();
    private final Level world;

    private static void sendMessagesForChunk(Level w, ChunkPos pos, ServerPlayer player, boolean add) {
        GlobalWireNetwork net = GlobalWireNetwork.getNetwork(w);
        Collection<ConnectionPoint> connsInChunk = net.getAllConnectorsIn(pos);
        for (ConnectionPoint cp : connsInChunk) {
            for (Connection conn : net.getLocalNet(cp).getConnections(cp)) {
                if (!WireSyncManager.shouldSendConnection(conn, pos, player, add, cp)) continue;
                WireLogger.logger.info("Sending connection {} ({}) for chunk change at {}", (Object)conn, (Object)add, (Object)pos);
                ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageWireSync(conn, add));
            }
        }
    }

    private static boolean shouldSendConnection(Connection conn, ChunkPos pos, ServerPlayer player, boolean add, ConnectionPoint currEnd) {
        if (conn.isInternal()) {
            return false;
        }
        ConnectionPoint other = conn.getOtherEnd(currEnd);
        ChunkPos otherChunk = new ChunkPos(other.getPosition());
        if (otherChunk.equals((Object)pos)) {
            return conn.isPositiveEnd(currEnd);
        }
        return wireWatchedChunksByPlayer.containsEntry((Object)player.m_142081_(), (Object)otherChunk);
    }

    private static void addPlayersTrackingPoint(Set<ServerPlayer> receivers, int x, int z, ServerLevel world) {
        ServerChunkCache chunkProvider = world.m_7726_();
        for (ServerPlayer e : chunkProvider.f_8325_.m_183262_(new ChunkPos(x >> 4, z >> 4), false)) {
            WireLogger.logger.debug("Watching player for {}, {}: {}", (Object)x, (Object)z, (Object)e);
            receivers.add(e);
        }
    }

    private static <T> void sendToPlayersForConnection(T msg, ServerLevel world, Connection c) {
        ApiUtils.addFutureServerTask((Level)world, () -> {
            HashSet<ServerPlayer> targets = new HashSet<ServerPlayer>();
            WireSyncManager.addPlayersTrackingPoint(targets, c.getEndA().getX(), c.getEndA().getZ(), world);
            WireSyncManager.addPlayersTrackingPoint(targets, c.getEndB().getX(), c.getEndB().getZ(), world);
            for (ServerPlayer p : targets) {
                ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> p), msg);
            }
        }, true);
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch ev) {
        ApiUtils.addFutureServerTask((Level)ev.getWorld(), () -> {
            if (wireWatchedChunksByPlayer.put((Object)ev.getPlayer().m_142081_(), (Object)ev.getPos())) {
                WireSyncManager.sendMessagesForChunk((Level)ev.getWorld(), ev.getPos(), ev.getPlayer(), true);
            }
        }, true);
    }

    @SubscribeEvent
    public static void onChunkUnWatch(ChunkWatchEvent.UnWatch ev) {
        ApiUtils.addFutureServerTask((Level)ev.getWorld(), () -> {
            if (wireWatchedChunksByPlayer.remove((Object)ev.getPlayer().m_142081_(), (Object)ev.getPos())) {
                WireSyncManager.sendMessagesForChunk((Level)ev.getWorld(), ev.getPos(), ev.getPlayer(), false);
            }
        }, true);
    }

    public WireSyncManager(Level world) {
        this.world = world;
    }

    @Override
    public void onConnectionAdded(Connection c) {
        if (!c.isInternal() && !this.world.f_46443_ && this.world instanceof ServerLevel) {
            WireSyncManager.sendToPlayersForConnection(new MessageWireSync(c, true), (ServerLevel)this.world, c);
        }
    }

    @Override
    public void onConnectionRemoved(Connection c) {
        if (!c.isInternal() && !this.world.f_46443_ && this.world instanceof ServerLevel) {
            WireSyncManager.sendToPlayersForConnection(new MessageWireSync(c, false), (ServerLevel)this.world, c);
        }
    }
}

