/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.BEDropLootEntry;
import blusunrize.immersiveengineering.common.util.loot.BluprintzLootFunction;
import blusunrize.immersiveengineering.common.util.loot.ConveyorCoverLootFunction;
import blusunrize.immersiveengineering.common.util.loot.DropInventoryLootEntry;
import blusunrize.immersiveengineering.common.util.loot.MBOriginalBlockLootEntry;
import blusunrize.immersiveengineering.common.util.loot.PropertyCountLootFunction;
import blusunrize.immersiveengineering.common.util.loot.SimpleSerializer;
import blusunrize.immersiveengineering.common.util.loot.WindmillLootFunction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public class IELootFunctions {
    public static LootItemFunctionType bluprintz;
    public static LootItemFunctionType windmill;
    public static LootItemFunctionType conveyorCover;
    public static LootItemFunctionType propertyCount;
    public static LootPoolEntryType dropInventory;
    public static LootPoolEntryType tileDrop;
    public static LootPoolEntryType multiblockOrigBlock;

    public static void register() {
        bluprintz = IELootFunctions.registerFunction(BluprintzLootFunction.ID, new SimpleSerializer<BluprintzLootFunction>(BluprintzLootFunction::new));
        windmill = IELootFunctions.registerFunction(WindmillLootFunction.ID, new SimpleSerializer<WindmillLootFunction>(WindmillLootFunction::new));
        conveyorCover = IELootFunctions.registerFunction(ConveyorCoverLootFunction.ID, new SimpleSerializer<ConveyorCoverLootFunction>(ConveyorCoverLootFunction::new));
        propertyCount = IELootFunctions.registerFunction(PropertyCountLootFunction.ID, (Serializer<? extends LootItemFunction>)new PropertyCountLootFunction.Serializer());
        dropInventory = IELootFunctions.registerEntry(DropInventoryLootEntry.ID, (Serializer<? extends LootPoolEntryContainer>)new DropInventoryLootEntry.Serializer());
        tileDrop = IELootFunctions.registerEntry(BEDropLootEntry.ID, (Serializer<? extends LootPoolEntryContainer>)new BEDropLootEntry.Serializer());
        multiblockOrigBlock = IELootFunctions.registerEntry(MBOriginalBlockLootEntry.ID, (Serializer<? extends LootPoolEntryContainer>)new MBOriginalBlockLootEntry.Serializer());
    }

    private static LootPoolEntryType registerEntry(ResourceLocation id, Serializer<? extends LootPoolEntryContainer> serializer) {
        return (LootPoolEntryType)Registry.m_122965_((Registry)Registry.f_122875_, (ResourceLocation)id, (Object)new LootPoolEntryType(serializer));
    }

    private static LootItemFunctionType registerFunction(ResourceLocation id, Serializer<? extends LootItemFunction> serializer) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)id, (Object)new LootItemFunctionType(serializer));
    }
}

