/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.cctweaked;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorBundledBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.GenericPeripheral;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.PeripheralCreator;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callbacks;
import com.google.common.base.Suppliers;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class ComputerCraftCompatModule
extends IECompatModule {
    public static Capability<IPeripheral> PERIPHERAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    private final Map<BlockEntityType<?>, PeripheralCreator<?>> knownPeripherals = new HashMap();
    private static final ResourceLocation CAP_NAME = ImmersiveEngineering.rl("cc_peripheral");

    @Override
    public void init() {
        ComputerCraftAPI.registerBundledRedstoneProvider((world, pos, direction) -> {
            int doNotHandle = -1;
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() != IEBlocks.Connectors.CONNECTOR_BUNDLED.get()) {
                return -1;
            }
            BlockEntity tile = world.m_7702_(pos);
            if (!(tile instanceof ConnectorBundledBlockEntity)) {
                return -1;
            }
            ConnectorBundledBlockEntity bundled = (ConnectorBundledBlockEntity)tile;
            int bits = 0;
            for (int color = 0; color < 16; ++color) {
                if (bundled.getValue(color) <= 0) continue;
                bits |= 1 << color;
            }
            return bits;
        });
        ConnectorBundledBlockEntity.EXTRA_SOURCES.add((world, emittingBlock, emittingSide) -> {
            int output = ComputerCraftAPI.getBundledRedstoneOutput((Level)world, (BlockPos)emittingBlock, (Direction)emittingSide);
            if (output == 0 || output == -1) {
                return null;
            }
            byte[] channelValues = new byte[16];
            for (int color = 0; color < 16; ++color) {
                channelValues[color] = (byte)(15 * (output >> color & 1));
            }
            return channelValues;
        });
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, this::attachPeripheral);
        try {
            for (Map.Entry<BlockEntityType<?>, CallbackOwner<?>> entry : Callbacks.getCallbacks().entrySet()) {
                this.knownPeripherals.put(entry.getKey(), new PeripheralCreator(entry.getValue()));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void attachPeripheral(AttachCapabilitiesEvent<BlockEntity> ev) {
        if (PERIPHERAL_CAPABILITY == null) {
            return;
        }
        final BlockEntity te = (BlockEntity)ev.getObject();
        final PeripheralCreator<?> creator = this.knownPeripherals.get(te.m_58903_());
        if (creator != null) {
            ev.addCapability(CAP_NAME, new ICapabilityProvider(){
                private final Supplier<LazyOptional<IPeripheral>> realPeripheral = Suppliers.memoize(() -> {
                    GenericPeripheral peripheral = creator.make(te);
                    if (peripheral != null) {
                        return CapabilityUtils.constantOptional(peripheral);
                    }
                    return LazyOptional.empty();
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == PERIPHERAL_CAPABILITY) {
                        return this.realPeripheral.get().cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

