/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.common.config.CachedConfig;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.CuriosCompatModule;
import blusunrize.immersiveengineering.common.util.compat.OneProbeCompatModule;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.ComputerCraftCompatModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.ModList;

public abstract class IECompatModule {
    public static HashMap<String, Class<? extends IECompatModule>> moduleClasses = new HashMap();
    public static Set<IECompatModule> modules = new HashSet<IECompatModule>();

    public static void doModulesPreInit() {
        for (Map.Entry<String, Class<? extends IECompatModule>> e : moduleClasses.entrySet()) {
            if (!ModList.get().isLoaded(e.getKey())) continue;
            try {
                CachedConfig.BooleanValue enabled;
                if ("ic2".equals(e.getKey()) && ModList.get().isLoaded("ic2-classic-spmod") || (enabled = IECommonConfig.compat.get(e.getKey())) == null || !((Boolean)enabled.get()).booleanValue()) continue;
                IECompatModule m = e.getValue().getConstructor(new Class[0]).newInstance(new Object[0]);
                modules.add(m);
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + e.getKey() + " could not be preInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesInit() {
        for (IECompatModule compat : modules) {
            try {
                compat.init();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesIMCs() {
        for (IECompatModule compat : modules) {
            try {
                compat.sendIMCs();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not send IMCs. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public void init() {
    }

    public void sendIMCs() {
    }

    static {
        moduleClasses.put("computercraft", ComputerCraftCompatModule.class);
        moduleClasses.put("curios", CuriosCompatModule.class);
        moduleClasses.put("theoneprobe", OneProbeCompatModule.class);
    }
}

