/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GenericDeferredWork {
    private static final List<Runnable> TO_RUN_ON_THREAD = new ArrayList<Runnable>();
    private static boolean done = false;

    public static void enqueue(Runnable toRun) {
        Preconditions.checkState((!done ? 1 : 0) != 0);
        TO_RUN_ON_THREAD.add(toRun);
    }

    public static void registerPotablePlant(ResourceLocation flower, Block fullPot) {
        GenericDeferredWork.enqueue(() -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(flower, () -> fullPot));
    }

    public static void registerDispenseBehavior(ItemLike item, DispenseItemBehavior behavior) {
        GenericDeferredWork.enqueue(() -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior));
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent ev) {
        ev.enqueueWork(() -> {
            TO_RUN_ON_THREAD.forEach(Runnable::run);
            done = true;
        });
    }
}

