/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class MessageWireSync
implements IMessage {
    private final ConnectionPoint start;
    private final ConnectionPoint end;
    private final WireType type;
    private final boolean added;
    private final Vec3 offsetStart;
    private final Vec3 offsetEnd;

    public MessageWireSync(Connection conn, boolean added) {
        this.start = conn.getEndA();
        this.end = conn.getEndB();
        this.type = conn.type;
        this.added = added;
        this.offsetStart = conn.getEndAOffset();
        this.offsetEnd = conn.getEndBOffset();
    }

    public MessageWireSync(FriendlyByteBuf buf) {
        this.added = buf.readBoolean();
        this.start = this.readConnPoint(buf);
        this.end = this.readConnPoint(buf);
        this.type = WireType.getValue(buf.m_130136_(128));
        this.offsetStart = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.offsetEnd = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    private ConnectionPoint readConnPoint(FriendlyByteBuf buf) {
        return new ConnectionPoint(buf.m_130135_(), buf.readInt());
    }

    private void writeConnPoint(ConnectionPoint cp, FriendlyByteBuf buf) {
        buf.m_130064_(cp.getPosition());
        buf.writeInt(cp.getIndex());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.added);
        this.writeConnPoint(this.start, buf);
        this.writeConnPoint(this.end, buf);
        buf.m_130070_(this.type.getUniqueName());
        buf.writeDouble(this.offsetStart.f_82479_).writeDouble(this.offsetStart.f_82480_).writeDouble(this.offsetStart.f_82481_);
        buf.writeDouble(this.offsetEnd.f_82479_).writeDouble(this.offsetEnd.f_82480_).writeDouble(this.offsetEnd.f_82481_);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            BlockEntity endTE;
            WireLogger.logger.debug("Processing sync for connection from {} to {}, type {}, adding {}", (Object)this.start, (Object)this.end, (Object)this.type, (Object)this.added);
            Player player = ImmersiveEngineering.proxy.getClientPlayer();
            Level w = player.f_19853_;
            GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(w);
            if (this.added) {
                globalNet.addConnection(new Connection(this.type, this.start, this.end, this.offsetStart, this.offsetEnd));
            } else if (globalNet.getNullableLocalNet(this.start) != null && globalNet.getNullableLocalNet(this.end) != null) {
                globalNet.removeConnection(new Connection(this.type, this.start, this.end, this.offsetStart, this.offsetEnd));
                this.removeProxyIfNoWires(this.start, globalNet);
                this.removeProxyIfNoWires(this.end, globalNet);
            }
            BlockEntity startTE = w.m_7702_(this.start.getPosition());
            if (startTE != null) {
                startTE.requestModelDataUpdate();
            }
            if ((endTE = w.m_7702_(this.end.getPosition())) != null) {
                endTE.requestModelDataUpdate();
            }
            BlockState state = w.m_8055_(this.start.getPosition());
            w.m_7260_(this.start.getPosition(), state, state, 3);
            state = w.m_8055_(this.end.getPosition());
            w.m_7260_(this.end.getPosition(), state, state, 3);
        });
        context.get().setPacketHandled(true);
    }

    private void removeProxyIfNoWires(ConnectionPoint point, GlobalWireNetwork globalNet) {
        LocalWireNetwork localNet = globalNet.getLocalNet(point);
        IImmersiveConnectable iic = localNet.getConnector(point);
        if (iic.isProxy() && !WireUtils.hasAnyConnections(globalNet, iic)) {
            globalNet.removeConnector(iic);
        }
    }
}

