/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientEventHandler;
import blusunrize.immersiveengineering.common.network.IMessage;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class MessageObstructedConnection
implements IMessage {
    private final Vec3 start;
    private final Vec3 end;
    private final BlockPos startB;
    private final BlockPos endB;
    private final Collection<BlockPos> blocking;
    private final WireType wireType;

    public MessageObstructedConnection(Connection conn, Collection<BlockPos> blocking) {
        this.blocking = blocking;
        this.start = conn.getEndAOffset();
        this.end = conn.getEndBOffset();
        this.startB = conn.getEndA().getPosition();
        this.endB = conn.getEndB().getPosition();
        this.wireType = conn.type;
    }

    public MessageObstructedConnection(FriendlyByteBuf buf) {
        this.start = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.end = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.startB = buf.m_130135_();
        this.endB = buf.m_130135_();
        int count = buf.readInt();
        this.blocking = new ArrayList<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            this.blocking.add(buf.m_130135_());
        }
        this.wireType = WireType.getValue(buf.m_130136_(100));
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.start.f_82479_).writeDouble(this.start.f_82480_).writeDouble(this.start.f_82481_);
        buf.writeDouble(this.end.f_82479_).writeDouble(this.end.f_82480_).writeDouble(this.end.f_82481_);
        buf.m_130064_(this.startB);
        buf.m_130064_(this.endB);
        buf.writeInt(this.blocking.size());
        for (BlockPos b : this.blocking) {
            buf.m_130064_(b);
        }
        buf.m_130070_(this.wireType.getUniqueName());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Connection conn = new Connection(this.wireType, new ConnectionPoint(this.startB, 0), new ConnectionPoint(this.endB, 0), this.start, this.end);
            conn.generateCatenaryData();
            ClientEventHandler.FAILED_CONNECTIONS.put(conn, (Pair<Collection<BlockPos>, AtomicInteger>)Pair.of(this.blocking, (Object)new AtomicInteger(200)));
        });
    }
}

