/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class RailgunProjectiles {
    public static void register() {
        RailgunHandler.registerStandardProjectile(IETags.ironRod, 16.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0xD8D8D8, 0xD8D8D8, 0xD8D8D8, 0xA8A8A8, 0x686868, 0x686868));
        RailgunHandler.registerStandardProjectile(IETags.aluminumRod, 10.0, 1.05).setColorMap(new RailgunHandler.RailgunRenderColors(0xD8D8D8, 0xD8D8D8, 0xD8D8D8, 0xA8A8A8, 0x686868, 0x686868));
        RailgunHandler.registerStandardProjectile(IETags.steelRod, 24.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0xB4B4B4, 0xB4B4B4, 0xB4B4B4, 0x7A7A7A, 0x555555, 0x555555));
        RailgunHandler.registerStandardProjectile(new ItemStack(IEItems.Misc.GRAPHITE_ELECTRODE), 30.0, 0.9).setColorMap(new RailgunHandler.RailgunRenderColors(0x242424, 0x242424, 0x242424, 0x171717, 0x171717, 657930));
        RailgunHandler.registerProjectile(() -> Ingredient.m_43911_((Tag)Tags.Items.RODS_BLAZE), new RailgunHandler.StandardRailgunProjectile(10.0, 1.05){

            @Override
            public void onHitTarget(Level world, HitResult target, @Nullable UUID shooter, Entity projectile) {
                if (target instanceof EntityHitResult) {
                    ((EntityHitResult)target).m_82443_().m_20254_(5);
                }
            }

            @Override
            public double getBreakChance(@Nullable UUID shooter, ItemStack ammo) {
                return 1.0;
            }
        }.setColorMap(new RailgunHandler.RailgunRenderColors(16773933, 16761088, 11758361, 12540416, 12540416, 9777920)));
        RailgunHandler.registerProjectile(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{IEItems.Tools.SAWBLADE}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
                Vec3 look = shooter.m_20154_();
                return new SawbladeEntity(shooter.m_20193_(), (LivingEntity)shooter, look.f_82479_ * 20.0, look.f_82480_ * 20.0, look.f_82481_ * 20.0, ammo);
            }
        });
        RailgunHandler.registerProjectile(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42713_}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public boolean isValidForTurret() {
                return false;
            }

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
                if (shooter != null) {
                    ammo.m_41622_(1, (LivingEntity)shooter, player -> player.m_21190_(shooter.m_7655_()));
                    ThrownTrident trident = new ThrownTrident(shooter.f_19853_, (LivingEntity)shooter, ammo);
                    trident.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, 2.5f, 1.0f);
                    if (shooter.m_150110_().f_35937_) {
                        trident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    return trident;
                }
                return defaultProjectile;
            }
        });
        RailgunHandler.registerProjectile(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public boolean isValidForTurret() {
                return false;
            }

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
                if (shooter != null) {
                    ThrownEnderpearl pearl = new ThrownEnderpearl(shooter.f_19853_, (LivingEntity)shooter);
                    pearl.m_37446_(ammo);
                    pearl.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, 2.5f, 1.0f);
                    return pearl;
                }
                return defaultProjectile;
            }
        });
    }
}

