/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEPotions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerEffects {
    public static void register() {
        ChemthrowerHandler.registerEffect((Tag<Fluid>)FluidTags.f_13131_, new ChemthrowerHandler.ChemthrowerEffect_Extinguish());
        ChemthrowerHandler.registerEffect(IETags.fluidPotion, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
                if (fluid.hasTag()) {
                    List effects = PotionUtils.m_43566_((CompoundTag)fluid.getOrCreateTag());
                    for (MobEffectInstance e : effects) {
                        MobEffectInstance newEffect = new MobEffectInstance(e.m_19544_(), (int)Math.ceil((double)e.m_19557_() * 0.05), e.m_19564_());
                        newEffect.setCurativeItems(new ArrayList(e.getCurativeItems()));
                        target.m_7292_(newEffect);
                    }
                }
            }

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidConcrete, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
                this.hit(target.f_19853_, target.m_142538_(), Direction.UP);
            }

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
                if (!(mop instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult brtr = (BlockHitResult)mop;
                BlockState hit = world.m_8055_(brtr.m_82425_());
                if (hit.m_60734_() != IEBlocks.StoneDecoration.CONCRETE_SPRAYED.get()) {
                    BlockPos pos = brtr.m_82425_().m_142300_(brtr.m_82434_());
                    if (!world.m_46859_(pos)) {
                        return;
                    }
                    AABB aabb = new AABB(pos);
                    List otherProjectiles = world.m_45976_(ChemthrowerShotEntity.class, aabb);
                    if (otherProjectiles.size() >= 8) {
                        this.hit(world, pos, brtr.m_82434_());
                    }
                }
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            private void hit(Level world, BlockPos pos, Direction side) {
                AABB aabb = new AABB(pos);
                List otherProjectiles = world.m_45976_(ChemthrowerShotEntity.class, aabb);
                for (ChemthrowerShotEntity shot : otherProjectiles) {
                    shot.m_146870_();
                }
                world.m_46597_(pos, IEBlocks.StoneDecoration.CONCRETE_SPRAYED.defaultBlockState());
                for (LivingEntity living : world.m_45976_(LivingEntity.class, aabb)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)IEPotions.CONCRETE_FEET.get(), Integer.MAX_VALUE));
                }
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidHerbicide, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
                if (!(mop instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult brtr = (BlockHitResult)mop;
                BlockState hit = world.m_8055_(brtr.m_82425_());
                if (hit.m_60620_((Tag)BlockTags.f_13035_)) {
                    world.m_7471_(brtr.m_82425_(), false);
                } else if (hit.m_60734_() instanceof SnowyDirtBlock || hit.m_60734_() instanceof FarmBlock) {
                    world.m_46597_(brtr.m_82425_(), Blocks.f_50493_.m_49966_());
                    BlockPos above = brtr.m_82425_().m_7494_();
                    if (world.m_8055_(above).m_60734_() instanceof BushBlock) {
                        world.m_7471_(above, false);
                    }
                }
                AABB aabb = new AABB(brtr.m_82425_()).m_82400_(0.25);
                List otherProjectiles = world.m_45976_(ChemthrowerShotEntity.class, aabb);
                for (ChemthrowerShotEntity shot : otherProjectiles) {
                    shot.m_146870_();
                }
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidCreosote, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 140, 0));
        ChemthrowerHandler.registerFlammable(IETags.fluidCreosote);
        ChemthrowerHandler.registerEffect(IETags.fluidBiodiesel, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 140, 1));
        ChemthrowerHandler.registerFlammable(IETags.fluidBiodiesel);
        ChemthrowerHandler.registerFlammable(IETags.fluidEthanol);
        ChemthrowerHandler.registerEffect(IETags.fluidRedstoneAcid, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.CONDUCTIVE.get(), 140, 1){

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
                BlockHitResult blockHit;
                block5: {
                    block4: {
                        if (!(mop instanceof BlockHitResult)) break block4;
                        blockHit = (BlockHitResult)mop;
                        if (world instanceof ServerLevel) break block5;
                    }
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)world;
                BlockState hit = world.m_8055_(blockHit.m_82425_());
                Block block = hit.m_60734_();
                if (block instanceof WeatheringCopper) {
                    WeatheringCopper copperBlock = (WeatheringCopper)block;
                    copperBlock.m_153046_(hit, serverLevel, blockHit.m_82425_(), world.f_46441_);
                }
            }
        });
    }
}

