/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.PlayerUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class SkylineHookEntity
extends Entity {
    public static final double GRAVITY = 10.0;
    private static final double MAX_SPEED = 2.5;
    private static final double LIMIT_SPEED = 0.25;
    public static final double MOVE_SPEED_HOR = 0.25;
    public static final double MOVE_SPEED_VERT = 0.1;
    private Connection connection;
    public ConnectionPoint start;
    public double linePos;
    public double horizontalSpeed;
    private double angle;
    public double friction = 0.99;
    public InteractionHand hand;
    private boolean limitSpeed;
    private final Set<BlockPos> ignoreCollisions = new HashSet<BlockPos>();

    public SkylineHookEntity(EntityType<SkylineHookEntity> type, Level world) {
        super(type, world);
    }

    public SkylineHookEntity(Level world, Connection connection, ConnectionPoint start, double linePos, InteractionHand hand, double horSpeed, boolean limitSpeed) {
        this((EntityType<SkylineHookEntity>)((EntityType)IEEntityTypes.SKYLINE_HOOK.get()), world);
        this.hand = hand;
        this.limitSpeed = limitSpeed;
        this.setConnectionAndPos(connection, start, linePos, horSpeed);
        Vec3 motion = this.m_20184_();
        float f1 = Mth.m_14116_((float)((float)(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
        this.m_146922_((float)(Math.atan2(motion.f_82481_, motion.f_82479_) * 180.0 / Math.PI) + 90.0f);
        this.m_146926_((float)(Math.atan2(f1, motion.f_82480_) * 180.0 / Math.PI) - 90.0f);
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
    }

    public void setConnectionAndPos(Connection c, ConnectionPoint start, double linePos, double speed) {
        c.generateCatenaryData();
        this.linePos = linePos;
        this.horizontalSpeed = speed;
        this.connection = c;
        this.start = start;
        Vec3 pos = this.connection.getPoint(this.linePos, start).m_82549_(Vec3.m_82528_((Vec3i)start.getPosition()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.m_146908_(), this.m_146909_());
        if (!this.connection.getCatenaryData().isVertical()) {
            this.angle = Math.atan2(this.connection.getCatenaryData().getDeltaZ(), this.connection.getCatenaryData().getDeltaX());
        }
        this.ignoreCollisions.clear();
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(this.f_19853_).getLocalNet(start);
        IImmersiveConnectable iicStart = net.getConnector(start);
        IImmersiveConnectable iicEnd = net.getConnector(c.getOtherEnd(start));
        if (iicStart != null && iicEnd != null) {
            this.ignoreCollisions.addAll(iicStart.getIgnored(iicEnd));
            this.ignoreCollisions.addAll(iicEnd.getIgnored(iicStart));
        }
    }

    protected void m_8097_() {
    }

    public boolean m_6783_(double distance) {
        double d1 = this.m_142469_().m_82309_() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void m_8119_() {
        double inLineDirection;
        if (this.f_19797_ == 1) {
            ImmersiveEngineering.proxy.startSkyhookSound(this);
        }
        Player player = null;
        List list = this.m_20197_();
        if (!list.isEmpty() && list.get(0) instanceof Player) {
            player = (Player)list.get(0);
        }
        if (this.connection == null || player == null || this.hand != null && player.m_21120_(this.hand).m_41720_() != IEItems.Misc.SKYHOOK.m_5456_()) {
            if (!this.f_19853_.f_46443_) {
                this.m_146870_();
            }
            return;
        }
        if (this.f_19797_ % 5 == 0 && !this.f_19853_.f_46443_) {
            this.sendUpdatePacketTo(player);
        }
        PlayerUtils.resetFloatingState((Entity)player);
        boolean moved = false;
        if (this.connection.getCatenaryData().isVertical()) {
            inLineDirection = (double)(-player.f_20902_) * Math.sin(Math.toRadians(player.m_146909_())) * Math.signum(this.connection.getCatenaryData().getDeltaY()) * this.getStartSignum();
        } else {
            float forward = player.f_20902_;
            double strafing = player.f_20900_;
            double playerAngle = Math.toRadians(player.m_146908_()) + 1.5707963267948966;
            double angleToLine = playerAngle - this.angle;
            inLineDirection = (Math.cos(angleToLine) * (double)forward + Math.sin(angleToLine) * strafing) * this.getStartSignum();
        }
        if (inLineDirection != 0.0) {
            double slope = this.connection.getSlope(this.linePos, this.start);
            double slopeInDirection = Math.signum(inLineDirection) * slope;
            double speed = 0.1;
            double slopeFactor = 1.0;
            if (!this.connection.getCatenaryData().isVertical()) {
                double lambda = Math.atan(slopeInDirection) / 1.5707963267948966;
                speed = lambda * 0.1 + (1.0 - lambda) * 0.25;
                slopeFactor = 1.0 / Math.sqrt(1.0 + slope * slope);
            }
            if (slopeInDirection > -0.1) {
                this.horizontalSpeed = (3.0 * this.horizontalSpeed + inLineDirection * speed * slopeFactor) / 4.0;
                moved = true;
            }
        }
        ConnectionPoint switchingAtPos = null;
        if (!moved) {
            double deltaVHor;
            if (this.connection.getCatenaryData().isVertical()) {
                deltaVHor = -10.0 * Math.signum(this.connection.getCatenaryData().getDeltaY() * this.getStartSignum());
            } else {
                double realLinePos = this.connection.transformPosition(this.linePos, this.start);
                double param = (realLinePos * this.getHorizontalLength() - this.connection.getCatenaryData().offsetX()) / this.connection.getCatenaryData().scale();
                double pos = Math.exp(param);
                double neg = 1.0 / pos;
                double cosh = (pos + neg) / 2.0;
                double sinh = (pos - neg) / 2.0;
                double vSquared = this.horizontalSpeed * this.horizontalSpeed * cosh * cosh * 20.0 * 20.0;
                deltaVHor = -sinh / (cosh * cosh) * (10.0 + vSquared / (this.connection.getCatenaryData().scale() * cosh));
                if (this.connection.getEndB().equals(this.start)) {
                    deltaVHor *= -1.0;
                }
            }
            this.horizontalSpeed += deltaVHor / 400.0;
        }
        if (this.limitSpeed) {
            double max;
            double totSpeed = this.getSpeed();
            double d = max = this.limitSpeed ? 0.25 : 2.5;
            if (totSpeed > max) {
                this.horizontalSpeed *= max / totSpeed;
            }
        }
        double horSpeedToUse = this.horizontalSpeed;
        if (this.horizontalSpeed > 0.0) {
            double distToEnd = this.getHorizontalLength() * (1.0 - this.linePos);
            if (this.horizontalSpeed > distToEnd) {
                switchingAtPos = this.connection.getOtherEnd(this.start);
                horSpeedToUse = distToEnd;
            }
        } else {
            double distToStart = -this.getHorizontalLength() * this.linePos;
            if (this.horizontalSpeed < distToStart) {
                switchingAtPos = this.start;
                horSpeedToUse = distToStart;
            }
        }
        this.horizontalSpeed *= this.friction;
        this.linePos += horSpeedToUse / this.getHorizontalLength();
        Vec3 pos = this.connection.getPoint(this.linePos, this.start).m_82549_(Vec3.m_82528_((Vec3i)this.start.getPosition()));
        this.m_20334_(pos.f_82479_ - this.m_20185_(), pos.f_82481_ - this.m_20189_(), pos.f_82480_ - this.m_20186_());
        if (!this.isValidPosition(pos.f_82479_, pos.f_82480_, pos.f_82481_, (LivingEntity)player)) {
            this.m_146870_();
            return;
        }
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        float f1 = Mth.m_14116_((float)((float)(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
        this.m_146922_((float)(Math.atan2(motion.f_82481_, motion.f_82479_) * 180.0 / Math.PI) + 90.0f);
        this.m_146926_((float)(Math.atan2(f1, motion.f_82480_) * 180.0 / Math.PI) - 90.0f);
        this.f_19860_ = this.m_146909_() - Mth.m_14177_((float)(this.m_146909_() - this.f_19860_));
        this.f_19859_ = this.m_146908_() - Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.m_146926_(this.f_19860_ + (this.m_146909_() - this.f_19860_) * 0.2f);
        this.m_146922_(this.f_19859_ + (this.m_146908_() - this.f_19859_) * 0.2f);
        if (this.m_20069_()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - motion.f_82479_ * (double)f3, this.m_20186_() - motion.f_82480_ * (double)f3, this.m_20189_() - motion.f_82481_ * (double)f3, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
        double dx = this.m_20185_() - this.f_19854_;
        double dy = this.m_20186_() - this.f_19855_;
        double dz = this.m_20189_() - this.f_19856_;
        int distTrvl = Math.round(Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz))) * 100.0f);
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (switchingAtPos != null) {
            this.switchConnection(switchingAtPos, player, horSpeedToUse);
        }
    }

    private void sendUpdatePacketTo(Player player) {
        if (player instanceof ServerPlayer) {
            ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSkyhookSync(this));
        }
    }

    public void switchConnection(ConnectionPoint posForSwitch, Player player, double lastHorSpeed) {
        Optional<Object> line = Optional.empty();
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(this.f_19853_).getLocalNet(posForSwitch);
        Collection<Connection> possible = net.getConnections(posForSwitch);
        if (possible != null) {
            Vec3 look = player.m_20154_();
            line = possible.stream().filter(c -> !c.equals(this.connection) && !c.isInternal()).max(Comparator.comparingDouble(c -> {
                c.generateCatenaryData();
                double factor = posForSwitch.equals(c.getEndA()) ? 1.0 : -1.0;
                return c.getCatenaryData().delta().m_82541_().m_82526_(look) * factor;
            }));
        }
        if (line.isPresent()) {
            Connection newCon = (Connection)line.get();
            double oldSpeedPerHor = SkylineHookEntity.getSpeedPerHor(this.connection, posForSwitch, 0.0);
            double newSpeedPerHor = SkylineHookEntity.getSpeedPerHor(newCon, posForSwitch, 0.0);
            double horConversionFactor = oldSpeedPerHor / newSpeedPerHor;
            this.setConnectionAndPos(newCon, posForSwitch, Math.abs(this.horizontalSpeed - lastHorSpeed) * horConversionFactor, Math.abs(this.horizontalSpeed) * horConversionFactor);
            this.sendUpdatePacketTo(player);
        } else {
            this.m_146870_();
        }
    }

    private static double getSpeedPerHor(Connection connection, ConnectionPoint start, double pos) {
        if (connection.getCatenaryData().isVertical()) {
            return 1.0;
        }
        double slope = connection.getSlope(pos, start);
        return Math.sqrt(slope * slope + 1.0);
    }

    public boolean isValidPosition(double x, double y, double z, @Nonnull LivingEntity player) {
        double tolerance = this.connection.getCatenaryData().isVertical() ? 5.0 : 10.0;
        double radius = player.m_20205_() / 2.0f;
        double height = player.m_20206_();
        double yOffset = this.m_6048_() + player.m_6049_();
        AABB playerBB = new AABB(x - radius, y + yOffset, z - radius, x + radius, y + yOffset + height, z + radius);
        double playerHeight = playerBB.f_82292_ - playerBB.f_82289_;
        AABB feet = new AABB(playerBB.f_82288_, playerBB.f_82289_, playerBB.f_82290_, playerBB.f_82291_, playerBB.f_82289_ + 0.05 * playerHeight, playerBB.f_82293_);
        List<VoxelShape> shapes = SkylineHelper.getCollisionBoxes((Entity)player, playerBB, this.f_19853_, this.ignoreCollisions);
        double totalCollisionVolume = 0.0;
        double totalCollisionArea = 0.0;
        VoxelShape playerShape = Shapes.m_83064_((AABB)playerBB);
        double playerVolume = this.getVolume(playerShape);
        double playerArea = playerVolume / playerHeight;
        VoxelShape feetShape = Shapes.m_83064_((AABB)feet);
        for (VoxelShape shape : shapes) {
            VoxelShape intersection = Shapes.m_83148_((VoxelShape)playerShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82689_);
            if ((totalCollisionVolume += this.getVolume(intersection)) * tolerance > playerVolume) {
                return false;
            }
            if (this.connection.getCatenaryData().isVertical() || !Shapes.m_83157_((VoxelShape)feetShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82689_)) continue;
            VoxelShape feetIntersectShape = Shapes.m_83148_((VoxelShape)feetShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82689_);
            for (AABB feetIntersect : feetIntersectShape.m_83299_()) {
                totalCollisionArea += (feetIntersect.f_82291_ - feetIntersect.f_82288_) * (feetIntersect.f_82293_ - feetIntersect.f_82290_);
            }
            if (!(totalCollisionArea > 0.5 * playerArea)) continue;
            return false;
        }
        return true;
    }

    private double getVolume(VoxelShape shape) {
        return shape.m_83299_().stream().mapToDouble(box -> (box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_)).sum();
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_20145_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public double m_6048_() {
        return -2.0;
    }

    protected void m_7380_(CompoundTag nbt) {
    }

    protected void m_7378_(CompoundTag nbt) {
    }

    public float m_6143_() {
        return 0.0f;
    }

    public float m_6073_() {
        return 1.0f;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.m_146870_();
        return true;
    }

    public boolean m_6109_() {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void handleDismount(Entity passenger) {
        ItemStack held;
        passenger.m_6021_(this.m_20185_(), this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_());
        passenger.m_20256_(this.m_20184_());
        if (this.m_20184_().f_82480_ < 0.0) {
            passenger.f_19789_ = SkylineHelper.fallDistanceFromSpeed(this.m_20184_().f_82480_);
            passenger.m_6853_(false);
        }
        passenger.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).ifPresent(CapabilitySkyhookData.SkyhookUserData::release);
        if (this.hand != null && passenger instanceof Player && (held = ((Player)passenger).m_21120_(this.hand)).m_41720_() == IEItems.Misc.SKYHOOK.m_5456_()) {
            ((Player)passenger).m_36335_().m_41524_(IEItems.Misc.SKYHOOK.m_5456_(), 10);
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.f_19853_.f_46443_) {
            ApiUtils.addFutureServerTask(this.f_19853_, () -> this.handleDismount(passenger));
        } else {
            ApiUtils.addFutureServerTask(this.f_19853_, () -> this.handleDismount(passenger), true);
        }
    }

    public void m_19890_(double x, double y, double z, float yaw, float pitch) {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public double getSpeed() {
        if (this.connection == null) {
            return 0.0;
        }
        if (this.connection.getCatenaryData().isVertical()) {
            return Math.abs(this.horizontalSpeed);
        }
        double slope = this.connection.getSlope(this.linePos, this.start);
        return Math.abs(this.horizontalSpeed) * Math.sqrt(1.0 + slope * slope);
    }

    private double getHorizontalLength() {
        if (this.connection.getCatenaryData().isVertical()) {
            return Math.abs(this.connection.getCatenaryData().getDeltaY());
        }
        return this.connection.getCatenaryData().horLength();
    }

    private double getStartSignum() {
        if (this.start.equals(this.connection.getEndA())) {
            return 1.0;
        }
        return -1.0;
    }
}

