/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ThermoelectricSourceSerializer
extends IERecipeSerializer<ThermoelectricSource> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.MetalDevices.THERMOELECTRIC_GEN);
    }

    @Override
    public ThermoelectricSource readFromJson(ResourceLocation recipeId, JsonObject json) {
        int temperature = json.get("tempKelvin").getAsInt();
        if (json.has("singleBlock")) {
            ResourceLocation blockName = new ResourceLocation(json.get("singleBlock").getAsString());
            Block singleBlock = (Block)Preconditions.checkNotNull((Object)((Block)ForgeRegistries.BLOCKS.getValue(blockName)));
            return new ThermoelectricSource(recipeId, (List<Block>)ImmutableList.of((Object)singleBlock), temperature);
        }
        ResourceLocation tagName = new ResourceLocation(json.get("blockTag").getAsString());
        Tag tag = SerializationTags.m_13199_().m_144452_(Registry.f_122901_).m_13404_(tagName);
        return new ThermoelectricSource(recipeId, (Tag<Block>)tag, temperature);
    }

    @Nullable
    public ThermoelectricSource fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        List<Block> blocks = PacketUtils.readList(buffer, buf -> (Block)buf.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
        int temperature = buffer.readInt();
        return new ThermoelectricSource(recipeId, blocks, temperature);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ThermoelectricSource recipe) {
        PacketUtils.writeList(buffer, recipe.getMatchingBlocks(), (b, buf) -> buf.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)b));
        buffer.writeInt(recipe.getTemperature());
    }
}

