/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CrusherRecipeSerializer
extends IERecipeSerializer<CrusherRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.CRUSHER);
    }

    @Override
    public CrusherRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = CrusherRecipeSerializer.readOutput(json.get("result"));
        Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        JsonArray array = json.getAsJsonArray("secondaries");
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        CrusherRecipe recipe = IEServerConfig.MACHINES.crusherConfig.apply(new CrusherRecipe(recipeId, output, input, energy));
        for (int i = 0; i < array.size(); ++i) {
            StackWithChance secondary = CrusherRecipeSerializer.readConditionalStackWithChance(array.get(i));
            if (secondary == null) continue;
            recipe.addToSecondaryOutput(secondary);
        }
        return recipe;
    }

    @Nullable
    public CrusherRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack output = buffer.m_130267_();
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        int secondaryCount = buffer.readInt();
        CrusherRecipe recipe = new CrusherRecipe(recipeId, output, input, energy);
        for (int i = 0; i < secondaryCount; ++i) {
            recipe.addToSecondaryOutput(StackWithChance.read(buffer));
        }
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buffer, CrusherRecipe recipe) {
        buffer.m_130055_(recipe.output);
        recipe.input.m_43923_(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.secondaryOutputs.size());
        for (StackWithChance secondaryOutput : recipe.secondaryOutputs) {
            secondaryOutput.write(buffer);
        }
    }
}

