/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.blocks.multiblocks.StaticTemplateManager;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingCalculator;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeReloadListener
implements ResourceManagerReloadListener {
    private final ServerResources serverResources;
    RecipeManager clientRecipeManager;

    public RecipeReloadListener(ServerResources serverResources) {
        this.serverResources = serverResources;
    }

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        if (this.serverResources != null) {
            Iterator it;
            this.startArcRecyclingRecipeGen(this.serverResources.m_136175_(), this.serverResources.m_136174_());
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (it = server.m_129785_().iterator()).hasNext()) {
                ApiUtils.addFutureServerTask((Level)it.next(), () -> StaticTemplateManager.syncMultiblockTemplates(PacketDistributor.ALL.noArg(), true));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        this.clientRecipeManager = event.getRecipeManager();
        if (!Minecraft.m_91087_().m_91091_()) {
            RecipeReloadListener.buildRecipeLists(this.clientRecipeManager);
        }
    }

    public static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.m_44051_();
        if (recipes.size() == 0) {
            return;
        }
        AlloyRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, AlloyRecipe.class, AlloyRecipe.TYPE);
        BlastFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceRecipe.class, BlastFurnaceRecipe.TYPE);
        BlastFurnaceFuel.blastFuels = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceFuel.class, BlastFurnaceFuel.TYPE);
        CokeOvenRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CokeOvenRecipe.class, CokeOvenRecipe.TYPE);
        ClocheRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ClocheRecipe.class, ClocheRecipe.TYPE);
        ClocheFertilizer.fertilizerList = RecipeReloadListener.filterRecipes(recipes, ClocheFertilizer.class, ClocheFertilizer.TYPE);
        BlueprintCraftingRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlueprintCraftingRecipe.class, BlueprintCraftingRecipe.TYPE);
        BlueprintCraftingRecipe.updateRecipeCategories();
        MetalPressRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MetalPressRecipe.class, MetalPressRecipe.TYPE);
        MetalPressRecipe unpackingRecipe = MetalPressPackingRecipes.getUnpackingContainer();
        MetalPressRecipe packingRecipe2x2 = MetalPressPackingRecipes.get2x2PackingContainer();
        MetalPressRecipe packingRecipe3x3 = MetalPressPackingRecipes.get3x3PackingContainer();
        MetalPressRecipe.recipeList.put(unpackingRecipe.m_6423_(), unpackingRecipe);
        MetalPressRecipe.recipeList.put(packingRecipe2x2.m_6423_(), packingRecipe2x2);
        MetalPressRecipe.recipeList.put(packingRecipe3x3.m_6423_(), packingRecipe3x3);
        MetalPressPackingRecipes.CRAFTING_RECIPE_MAP = RecipeReloadListener.filterRecipes(recipes, CraftingRecipe.class, RecipeType.f_44107_);
        MetalPressRecipe.updateRecipesByMold();
        BottlingMachineRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BottlingMachineRecipe.class, BottlingMachineRecipe.TYPE);
        CrusherRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CrusherRecipe.class, CrusherRecipe.TYPE);
        SawmillRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, SawmillRecipe.class, SawmillRecipe.TYPE);
        FermenterRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, FermenterRecipe.class, FermenterRecipe.TYPE);
        SqueezerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, SqueezerRecipe.class, SqueezerRecipe.TYPE);
        RefineryRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, RefineryRecipe.class, RefineryRecipe.TYPE);
        MixerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MixerRecipe.class, MixerRecipe.TYPE);
        MineralMix.mineralList = RecipeReloadListener.filterRecipes(recipes, MineralMix.class, MineralMix.TYPE);
        GeneratorFuel.ALL_FUELS = RecipeReloadListener.filterRecipes(recipes, GeneratorFuel.class, GeneratorFuel.TYPE).values();
        ThermoelectricSource.ALL_SOURCES = RecipeReloadListener.filterRecipes(recipes, ThermoelectricSource.class, ThermoelectricSource.TYPE).values();
        ArcFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ArcFurnaceRecipe.class, ArcFurnaceRecipe.TYPE);
    }

    private void startArcRecyclingRecipeGen(RecipeManager recipeManager, TagContainer tags) {
        Collection recipes = recipeManager.m_44051_();
        new ArcRecyclingCalculator(recipes, tags).run();
    }

    static <R extends Recipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<Recipe<?>> recipes, Class<R> recipeClass, RecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.m_6671_() == recipeType).flatMap(r -> {
            if (r instanceof GeneratedListRecipe) {
                GeneratedListRecipe genList = (GeneratedListRecipe)r;
                return genList.getSubRecipes().stream();
            }
            return Stream.of(r);
        }).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.m_6423_(), recipe -> recipe));
    }
}

