/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class MultiblockProcess<R extends MultiblockRecipe> {
    public R recipe;
    public int processTick;
    public int maxTicks;
    public int energyPerTick;
    public boolean clearProcess = false;

    public MultiblockProcess(R recipe) {
        this.recipe = recipe;
        this.processTick = 0;
        this.maxTicks = ((MultiblockRecipe)this.recipe).getTotalProcessTime();
        this.energyPerTick = ((MultiblockRecipe)this.recipe).getTotalProcessEnergy() / this.maxTicks;
    }

    protected List<ItemStack> getRecipeItemOutputs(PoweredMultiblockBlockEntity<?, R> multiblock) {
        return this.recipe.getActualItemOutputs(multiblock);
    }

    protected List<FluidStack> getRecipeFluidOutputs(PoweredMultiblockBlockEntity<?, R> multiblock) {
        return this.recipe.getActualFluidOutputs(multiblock);
    }

    public boolean canProcess(PoweredMultiblockBlockEntity<?, R> multiblock) {
        if (multiblock.energyStorage.extractEnergy(this.energyPerTick, true) == this.energyPerTick) {
            List<FluidStack> fluidOutputs;
            List<ItemStack> outputs = this.getRecipeItemOutputs(multiblock);
            if (outputs != null && !outputs.isEmpty()) {
                int[] outputSlots = multiblock.getOutputSlots();
                for (ItemStack output : outputs) {
                    if (output.m_41619_()) continue;
                    boolean canOutput = false;
                    if (outputSlots == null) {
                        canOutput = true;
                    } else {
                        for (int iOutputSlot : outputSlots) {
                            ItemStack s = (ItemStack)multiblock.getInventory().get(iOutputSlot);
                            if (!s.m_41619_() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.m_41613_() + output.m_41613_() > multiblock.getSlotLimit(iOutputSlot))) continue;
                            canOutput = true;
                            break;
                        }
                    }
                    if (canOutput) continue;
                    return false;
                }
            }
            if ((fluidOutputs = ((MultiblockRecipe)this.recipe).getFluidOutputs()) != null && !fluidOutputs.isEmpty()) {
                IFluidTank[] tanks = multiblock.getInternalTanks();
                int[] outputTanks = multiblock.getOutputTanks();
                for (FluidStack output : fluidOutputs) {
                    if (output == null || output.getAmount() <= 0) continue;
                    boolean canOutput = false;
                    if (tanks == null || outputTanks == null) {
                        canOutput = true;
                    } else {
                        for (int iOutputTank : outputTanks) {
                            if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                            canOutput = true;
                            break;
                        }
                    }
                    if (canOutput) continue;
                    return false;
                }
            }
            return multiblock.additionalCanProcessCheck(this);
        }
        return false;
    }

    public void doProcessTick(PoweredMultiblockBlockEntity<?, R> multiblock) {
        int energyExtracted = this.energyPerTick;
        int ticksAdded = 1;
        if (this.recipe.getMultipleProcessTicks() > 1) {
            int possibleTicks;
            int averageInsertion = multiblock.energyStorage.getAverageInsertion();
            if ((averageInsertion = multiblock.energyStorage.extractEnergy(averageInsertion, true)) > energyExtracted && (possibleTicks = Math.min(averageInsertion / this.energyPerTick, Math.min(this.recipe.getMultipleProcessTicks(), this.maxTicks - this.processTick))) > 1) {
                ticksAdded = possibleTicks;
                energyExtracted *= ticksAdded;
            }
        }
        multiblock.energyStorage.extractEnergy(energyExtracted, false);
        this.processTick += ticksAdded;
        if (this.processTick >= this.maxTicks) {
            this.processFinish(multiblock);
        }
    }

    protected void processFinish(PoweredMultiblockBlockEntity<?, R> multiblock) {
        List<FluidStack> fluidOutputs;
        List<ItemStack> outputs = this.getRecipeItemOutputs(multiblock);
        if (outputs != null && !outputs.isEmpty()) {
            int[] outputSlots = multiblock.getOutputSlots();
            block0: for (ItemStack output : outputs) {
                if (output.m_41619_()) continue;
                if (outputSlots == null || multiblock.getInventory() == null) {
                    multiblock.doProcessOutput(output.m_41777_());
                    continue;
                }
                for (Object iOutputSlot : (Object)outputSlots) {
                    ItemStack s = (ItemStack)multiblock.getInventory().get((int)iOutputSlot);
                    if (s.m_41619_()) {
                        multiblock.getInventory().set((int)iOutputSlot, (Object)output.m_41777_());
                        continue block0;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.m_41613_() + output.m_41613_() > multiblock.getSlotLimit((int)iOutputSlot)) continue;
                    ((ItemStack)multiblock.getInventory().get((int)iOutputSlot)).m_41769_(output.m_41613_());
                    continue block0;
                }
            }
        }
        if ((fluidOutputs = this.getRecipeFluidOutputs(multiblock)) != null && !fluidOutputs.isEmpty()) {
            IFluidTank[] tanks = multiblock.getInternalTanks();
            int[] outputTanks = multiblock.getOutputTanks();
            block2: for (FluidStack output : fluidOutputs) {
                if (output == null || output.getAmount() <= 0) continue;
                if (tanks == null || outputTanks == null) {
                    multiblock.doProcessFluidOutput(output);
                    continue;
                }
                for (int iOutputTank : outputTanks) {
                    if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                    tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.EXECUTE);
                    continue block2;
                }
            }
        }
        multiblock.onProcessFinish(this);
        this.clearProcess = true;
    }

    public abstract void writeExtraDataToNBT(CompoundTag var1);
}

