/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.utils.BasicClientProperties;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class IETemplateMultiblock
extends TemplateMultiblock {
    private final IEBlocks.BlockEntry<?> baseState;

    public IETemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, IEBlocks.BlockEntry<?> baseState) {
        super(loc, masterFromOrigin, triggerFromOrigin, size, (Map<Block, Tag<Block>>)ImmutableMap.of());
        this.baseState = baseState;
    }

    @Override
    protected void replaceStructureBlock(StructureTemplate.StructureBlockInfo info, Level world, BlockPos actualPos, boolean mirrored, Direction clickDirection, Vec3i offsetFromMaster) {
        BlockState state = this.baseState.get().m_49966_();
        if (!offsetFromMaster.equals((Object)Vec3i.f_123288_)) {
            state = (BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        }
        world.m_46597_(actualPos, state);
        BlockEntity curr = world.m_7702_(actualPos);
        if (curr instanceof MultiblockPartBlockEntity) {
            MultiblockPartBlockEntity tile = (MultiblockPartBlockEntity)curr;
            tile.formed = true;
            tile.offsetToMaster = new BlockPos(offsetFromMaster);
            tile.posInMultiblock = info.f_74675_;
            if (state.m_61138_((Property)IEProperties.MIRRORED)) {
                tile.setMirrored(mirrored);
            }
            tile.setFacing(this.transformDirection(clickDirection.m_122424_()));
            tile.m_6596_();
            world.m_7696_(actualPos, world.m_8055_(actualPos).m_60734_(), 255, 0);
        } else {
            IELogger.logger.error("Expected MB TE at {} during placement", (Object)actualPos);
        }
    }

    public Direction transformDirection(Direction original) {
        return original;
    }

    public Direction untransformDirection(Direction transformed) {
        return transformed;
    }

    public BlockPos multiblockToModelPos(BlockPos posInMultiblock) {
        return posInMultiblock.m_141950_((Vec3i)this.masterFromOrigin);
    }

    @Override
    public Vec3i getSize(@Nullable Level world) {
        return this.size;
    }

    @Override
    @Nonnull
    protected StructureTemplate getTemplate(@Nullable Level world) {
        StructureTemplate result = super.getTemplate(world);
        Preconditions.checkState((boolean)result.m_163801_().equals((Object)this.size), (String)"Wrong template size for multiblock %s, template size: %s", (Object)this.getTemplateLocation(), (Object)result.m_163801_());
        return result;
    }

    @Override
    protected void prepareBlockForDisassembly(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof MultiblockPartBlockEntity) {
            MultiblockPartBlockEntity multiblockBE = (MultiblockPartBlockEntity)be;
            multiblockBE.formed = false;
        } else if (be != null) {
            IELogger.logger.error("Expected multiblock TE at {}, got {}", (Object)pos, (Object)be);
        }
    }

    @Override
    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
        consumer.accept(new BasicClientProperties(this));
    }

    public ResourceLocation getBlockName() {
        return this.baseState.getId();
    }

    @Override
    public Component getDisplayName() {
        return this.baseState.get().m_49954_();
    }
}

