/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RefineryBlockEntity
extends PoweredMultiblockBlockEntity<RefineryBlockEntity, RefineryRecipe>
implements IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IInteractionObjectIE<RefineryBlockEntity>,
IEBlockInterfaces.IBlockBounds {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000), new FluidTank(24000), new FluidTank(24000)};
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private static final int SLOT_CATALYST = 0;
    private static final int SLOT_CONTAINER_IN = 1;
    private static final int SLOT_CONTAINER_OUT = 2;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(RefineryBlockEntity::getShape);
    private static final PoweredMultiblockBlockEntity.MultiblockFace outputOffset = new PoweredMultiblockBlockEntity.MultiblockFace(2, 0, 2, RelativeBlockFace.FRONT);
    private static final Set<PoweredMultiblockBlockEntity.MultiblockFace> inputOffsets = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(0, 0, 1, RelativeBlockFace.LEFT), (Object)new PoweredMultiblockBlockEntity.MultiblockFace(4, 0, 1, RelativeBlockFace.RIGHT));
    private final MultiblockCapability<IFluidHandler> fluidInput = MultiblockCapability.make(this, be -> be.fluidInput, MultiblockPartBlockEntity::master, this.registerFluidInput(new IFluidTank[]{this.tanks[0], this.tanks[1]}));
    private final MultiblockCapability<IFluidHandler> fluidOutput = MultiblockCapability.make(this, be -> be.fluidOutput, MultiblockPartBlockEntity::master, this.registerFluidOutput(new IFluidTank[]{this.tanks[2]}));
    private final MultiblockCapability<IFluidHandler> allFluids = MultiblockCapability.make(this, be -> be.allFluids, MultiblockPartBlockEntity::master, this.registerFluidView((IFluidTank[])this.tanks));

    public RefineryBlockEntity(BlockEntityType<RefineryBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.REFINERY, 16000, true, type, pos, state);
        this.tanks[0].setValidator(fs -> RefineryRecipe.findIncompleteRefineryRecipe(fs, this.tanks[1].getFluid()).isPresent());
        this.tanks[1].setValidator(fs -> RefineryRecipe.findIncompleteRefineryRecipe(fs, this.tanks[0].getFluid()).isPresent());
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tanks[0].readFromNBT(nbt.m_128469_("tank0"));
            this.tanks[1].readFromNBT(nbt.m_128469_("tank1"));
            this.tanks[2].readFromNBT(nbt.m_128469_("tank2"));
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128365_("tank0", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
            nbt.m_128365_("tank1", (Tag)this.tanks[1].writeToNBT(new CompoundTag()));
            nbt.m_128365_("tank2", (Tag)this.tanks[2].writeToNBT(new CompoundTag()));
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void tickServer() {
        RefineryRecipe recipe;
        super.tickServer();
        boolean update = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (this.tanks[0].getFluidAmount() > 0 || this.tanks[1].getFluidAmount() > 0) && (recipe = RefineryRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid(), (ItemStack)this.inventory.get(0))) != null) {
            int[] nArray;
            MultiblockProcessInMachine<RefineryRecipe> multiblockProcessInMachine = new MultiblockProcessInMachine<RefineryRecipe>(recipe, new int[0]);
            if (this.tanks[0].getFluidAmount() > 0 && this.tanks[1].getFluidAmount() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else if (this.tanks[0].getFluidAmount() > 0) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 0;
            } else {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 1;
            }
            MultiblockProcessInMachine<RefineryRecipe> process = multiblockProcessInMachine.setInputTanks(nArray);
            if (this.addProcessToQueue(process, true)) {
                this.addProcessToQueue(process, false);
                update = true;
            }
        }
        Direction fw = this.getFacing().m_122424_();
        if (update |= FluidUtils.multiblockFluidOutput(this.f_58857_, this.m_58899_().m_142082_(0, -1, 0).m_142300_(fw), fw, this.tanks[2], 1, 2, arg_0 -> this.inventory.get(arg_0), (arg_0, arg_1) -> this.inventory.set(arg_0, arg_1))) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        RefineryBlockEntity master = (RefineryBlockEntity)this.master();
        if (master != null) {
            int tank = -1;
            if (this.posInMultiblock.m_123341_() != 2 && this.posInMultiblock.m_123343_() < 2 && this.posInMultiblock.m_123342_() > 0) {
                tank = this.posInMultiblock.m_123341_() < 2 == this.getIsMirrored() ? 1 : 0;
            } else if (this.posInMultiblock.m_123341_() == 2 && this.posInMultiblock.m_123343_() == 2) {
                tank = 2;
            }
            if (tank >= 0 && FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)master.tanks[tank])) {
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.m_123343_() % 2 == 0 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123341_() % 4 == 0) {
            List<AABB> list = Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 0, new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.25, 0.5, 0.0, 0.5, 1.375, 0.25));
            if (new BlockPos(4, 0, 2).equals((Object)posInMultiblock)) {
                list.add(new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
                list.add(new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            }
            return list;
        }
        if (posInMultiblock.m_123343_() % 2 == 0 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123341_() % 2 == 1) {
            return Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 1, new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.0, 0.5, 0.0, 0.25, 1.375, 0.25));
        }
        if (posInMultiblock.m_123343_() < 2 && posInMultiblock.m_123342_() > 0 && posInMultiblock.m_123341_() % 4 == 0) {
            float maxY;
            float minZ = -0.25f;
            float maxZ = 1.25f;
            float minY = posInMultiblock.m_123342_() == 1 ? 0.5f : -0.5f;
            float f = maxY = posInMultiblock.m_123342_() == 1 ? 2.0f : 1.0f;
            if (posInMultiblock.m_123343_() == 0) {
                minZ += 1.0f;
                maxZ += 1.0f;
            }
            return Utils.flipBoxes(false, posInMultiblock.m_123341_() == 4, new AABB(0.5, (double)minY, (double)minZ, 2.0, (double)maxY, (double)maxZ));
        }
        if (posInMultiblock.m_123343_() < 2 && posInMultiblock.m_123342_() > 0 && posInMultiblock.m_123341_() % 2 == 1) {
            float maxY;
            float minZ = -0.25f;
            float maxZ = 1.25f;
            float minY = posInMultiblock.m_123342_() == 1 ? 0.5f : -0.5f;
            float f = maxY = posInMultiblock.m_123342_() == 1 ? 2.0f : 1.0f;
            if (posInMultiblock.m_123343_() == 0) {
                minZ += 1.0f;
                maxZ += 1.0f;
            }
            return Utils.flipBoxes(false, posInMultiblock.m_123341_() == 3, new AABB(-0.5, (double)minY, (double)minZ, 1.0, (double)maxY, (double)maxZ));
        }
        if (ImmutableSet.of((Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(3, 0, 2)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(4, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));
        }
        return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(4, 1, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<RefineryRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<RefineryRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 1;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 1;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<RefineryRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{2};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.allFluids.getAndCast();
            }
            PoweredMultiblockBlockEntity.MultiblockFace relativeFace = this.asRelativeFace(side);
            if (outputOffset.equals(relativeFace)) {
                return this.fluidOutput.getAndCast();
            }
            if (inputOffsets.contains(relativeFace)) {
                return this.fluidInput.getAndCast();
            }
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public RefineryRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected RefineryRecipe getRecipeForId(ResourceLocation id) {
        return RefineryRecipe.recipeList.get(id);
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public RefineryBlockEntity getGuiMaster() {
        return (RefineryBlockEntity)this.master();
    }

    @Override
    public IEContainerTypes.BEContainer<RefineryBlockEntity, ?> getContainerType() {
        return IEContainerTypes.REFINERY;
    }
}

