/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConveyorBeltBlockEntity<T extends IConveyorBelt>
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorBlockEntity<T>,
IEServerTickableBE {
    public static final Map<IConveyorType<?>, Supplier<BlockEntityType<?>>> BE_TYPES = new Reference2ObjectOpenHashMap();
    private final T conveyorBeltSubtype;
    private static final VoxelShape COLISIONBB = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private final ResettableCapability<IItemHandler> insertionCap = this.registerCapability(new ConveyorInventoryHandler(this));

    public ConveyorBeltBlockEntity(IConveyorType<T> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)Preconditions.checkNotNull(ConveyorHandler.getBEType(type), (Object)("Not BE type for " + type)), pos, state);
        this.conveyorBeltSubtype = ConveyorHandler.getConveyor(type, this);
    }

    @Override
    @Nullable
    public T getConveyorInstance() {
        return this.conveyorBeltSubtype;
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.onEntityCollision(entity);
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (nbt.m_128425_("conveyorBeltSubtypeNBT", 10)) {
            this.conveyorBeltSubtype.readConveyorNBT(nbt.m_128469_("conveyorBeltSubtypeNBT"));
        }
        if (descPacket && this.f_58857_ != null) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (this.conveyorBeltSubtype != null) {
            nbt.m_128365_("conveyorBeltSubtypeNBT", (Tag)this.conveyorBeltSubtype.writeConveyorNBT());
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConveyorBlock.FACING;
    }

    @Override
    public Direction getFacing() {
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacing();
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_QUADRANT;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return !entity.m_6144_();
    }

    @Override
    public void afterRotation(Direction oldDir, Direction newDir) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.afterRotation(oldDir, newDir);
        }
    }

    @Override
    public void tickServer() {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.tickServer();
        }
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (player.m_6144_() && this.conveyorBeltSubtype != null && this.conveyorBeltSubtype.changeConveyorDirection()) {
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
                this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        DyeColor dye;
        boolean update;
        if (this.conveyorBeltSubtype != null && (update = this.conveyorBeltSubtype.getType().canBeDyed() && Utils.isDye(heldItem) ? (dye = Utils.getDye(heldItem)) != null && this.conveyorBeltSubtype.setDyeColour(dye) : this.conveyorBeltSubtype.playerInteraction(player, hand, heldItem, hitX, hitY, hitZ, side))) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        if (this.conveyorBeltSubtype != null) {
            return this.conveyorBeltSubtype.getCollisionShape();
        }
        return COLISIONBB;
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        if (this.conveyorBeltSubtype != null) {
            return this.conveyorBeltSubtype.getSelectionShape();
        }
        return COLISIONBB;
    }

    @Nonnull
    public <T2> LazyOptional<T2> getCapability(@Nonnull Capability<T2> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean isRSPowered() {
        return super.isRSPowered();
    }

    @SubscribeEvent
    public static void registerConveyorBEsAndBlocks(RegistryEvent.NewRegistry ev) {
        for (IConveyorType<?> type : ConveyorHandler.getConveyorTypes()) {
            RegistryObject beType = IEBlockEntities.REGISTER.register(type.getId().m_135815_(), () -> new BlockEntityType((pos, state) -> new ConveyorBeltBlockEntity(type, pos, state), (Set)ImmutableSet.of((Object)ConveyorHandler.getBlock(type)), null));
            BE_TYPES.put(type, (Supplier<BlockEntityType<?>>)beType);
        }
        IEBlocks.MetalDevices.initConveyors();
    }

    public static class ConveyorInventoryHandler
    implements IItemHandlerModifiable {
        ConveyorBeltBlockEntity conveyor;

        public ConveyorInventoryHandler(ConveyorBeltBlockEntity conveyor) {
            this.conveyor = conveyor;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.conveyor.getConveyorInstance().isBlocked()) {
                return stack;
            }
            if (!simulate) {
                ItemEntity entity = new ItemEntity(this.conveyor.getLevelNonnull(), (double)this.conveyor.m_58899_().m_123341_() + 0.5, (double)this.conveyor.m_58899_().m_123342_() + 0.1875, (double)this.conveyor.m_58899_().m_123343_() + 0.5, stack.m_41777_());
                entity.m_20256_(Vec3.f_82478_);
                this.conveyor.getLevelNonnull().m_7967_((Entity)entity);
                if (this.conveyor.conveyorBeltSubtype != null) {
                    this.conveyor.conveyorBeltSubtype.onItemDeployed(entity);
                }
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

