/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class BottlingMachineBlockEntity
extends PoweredMultiblockBlockEntity<BottlingMachineBlockEntity, MultiblockRecipe>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds,
IEClientTickableBE {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_LIFT_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000)};
    public List<BottlingProcess> bottlingProcessQueue = new ArrayList<BottlingProcess>();
    private final CapabilityReference<IItemHandler> outputCap = CapabilityReference.forBlockEntityAt(this, () -> {
        Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(2, 1, 1)).m_142300_(outDir), outDir.m_122424_());
    }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new BottlingMachineInventoryHandler(this)));
    private final MultiblockCapability<IFluidHandler> fluidCap = MultiblockCapability.make(this, be -> be.fluidCap, MultiblockPartBlockEntity::master, this.registerFluidInput((IFluidTank[])this.tanks));

    public BottlingMachineBlockEntity(BlockEntityType<BottlingMachineBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.BOTTLING_MACHINE, 16000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        ListTag processNBT = nbt.m_128437_("bottlingQueue", 10);
        this.bottlingProcessQueue.clear();
        for (int i = 0; i < processNBT.size(); ++i) {
            CompoundTag tag = processNBT.m_128728_(i);
            BottlingProcess process = BottlingProcess.readFromNBT(tag);
            this.bottlingProcessQueue.add(process);
        }
        this.tanks[0].readFromNBT(nbt.m_128469_("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        ListTag processNBT = new ListTag();
        for (BottlingProcess process : this.bottlingProcessQueue) {
            processNBT.add((Object)process.writeToNBT());
        }
        nbt.m_128365_("bottlingQueue", (Tag)processNBT);
        nbt.m_128365_("tank", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
    }

    @Override
    public void tickClient() {
        if (!this.shouldRenderAsActive()) {
            return;
        }
        for (BottlingProcess process : this.bottlingProcessQueue) {
            ++process.processTick;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.isRSDisabled()) {
            return;
        }
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<BottlingProcess> processIterator = this.bottlingProcessQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            BottlingProcess process = processIterator.next();
            if (process.processStep(this)) {
                ++this.tickedProcesses;
            }
            if (!process.processFinished) continue;
            ItemStack output = !((ItemStack)process.items.get(1)).m_41619_() ? (ItemStack)process.items.get(1) : (ItemStack)process.items.get(0);
            this.doProcessOutput(output);
            processIterator.remove();
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (new BlockPos(1, 0, 0).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (this.posInMultiblock.m_123342_() == 0 || new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (this.posInMultiblock.m_123343_() == 1 && this.posInMultiblock.m_123342_() == 1) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        if (new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
        }
        if (new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) {
            float xMax;
            float zMin;
            float xMin;
            Direction f;
            Direction direction = f = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            float f2 = f == Direction.EAST ? -0.0625f : (f == Direction.WEST ? 0.25f : (this.getFacing() == Direction.WEST ? 0.125f : (xMin = this.getFacing() == Direction.EAST ? 0.25f : 0.0f)));
            float f3 = this.getFacing() == Direction.NORTH ? 0.125f : (this.getFacing() == Direction.SOUTH ? 0.25f : (f == Direction.SOUTH ? -0.0625f : (zMin = f == Direction.NORTH ? 0.25f : 0.0f)));
            float f4 = f == Direction.EAST ? 0.75f : (f == Direction.WEST ? 1.0625f : (this.getFacing() == Direction.WEST ? 0.75f : (xMax = this.getFacing() == Direction.EAST ? 0.875f : 1.0f)));
            float zMax = this.getFacing() == Direction.NORTH ? 0.75f : (this.getFacing() == Direction.SOUTH ? 0.875f : (f == Direction.SOUTH ? 0.75f : (f == Direction.NORTH ? 1.0625f : 1.0f)));
            return Shapes.m_83048_((double)xMin, (double)0.0625, (double)zMin, (double)xMax, (double)0.6875, (double)zMax);
        }
        if (new BlockPos(1, 2, 1).equals((Object)this.posInMultiblock)) {
            float xMin = this.getFacing() == Direction.WEST ? 0.0f : 0.21875f;
            float zMin = this.getFacing() == Direction.NORTH ? 0.0f : 0.21875f;
            float xMax = this.getFacing() == Direction.EAST ? 1.0f : 0.78125f;
            float zMax = this.getFacing() == Direction.SOUTH ? 1.0f : 0.78125f;
            return Shapes.m_83048_((double)xMin, (double)-0.4375, (double)zMin, (double)xMax, (double)0.5625, (double)zMax);
        }
        if (new BlockPos(1, 2, 0).equals((Object)this.posInMultiblock)) {
            float xMax;
            float zMin;
            float xMin;
            float f = this.getFacing() == Direction.WEST ? 0.8125f : (xMin = this.getFacing() == Direction.EAST ? 0.0f : 0.125f);
            float f5 = this.getFacing() == Direction.NORTH ? 0.8125f : (zMin = this.getFacing() == Direction.SOUTH ? 0.0f : 0.125f);
            float f6 = this.getFacing() == Direction.WEST ? 1.0f : (xMax = this.getFacing() == Direction.EAST ? 0.1875f : 0.875f);
            float zMax = this.getFacing() == Direction.NORTH ? 1.0f : (this.getFacing() == Direction.SOUTH ? 0.1875f : 0.875f);
            return Shapes.m_83048_((double)xMin, (double)-1.0, (double)zMin, (double)xMax, (double)0.25, (double)zMax);
        }
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    protected boolean shouldRenderAsActiveImpl() {
        return this.energyStorage.getEnergyStored() > 0 && !this.isRSDisabled() && !this.bottlingProcessQueue.isEmpty();
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && !world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.m_6084_()) {
                BottlingMachineBlockEntity master = (BottlingMachineBlockEntity)this.master();
                if (master == null) {
                    return;
                }
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41619_()) {
                    return;
                }
                if (master.bottlingProcessQueue.size() < master.getProcessQueueMaxLength()) {
                    float dist = 1.0f;
                    BottlingProcess p = null;
                    if (master.bottlingProcessQueue.size() > 0 && (p = master.bottlingProcessQueue.get(master.bottlingProcessQueue.size() - 1)) != null) {
                        dist = (float)p.processTick / (float)p.maxProcessTick;
                    }
                    if (p != null && dist < master.getMinProcessDistance((MultiblockProcess<MultiblockRecipe>)null)) {
                        return;
                    }
                    p = new BottlingProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    master.bottlingProcessQueue.add(p);
                    master.m_6596_();
                    master.markContainingBlockForUpdate(null);
                    stack = stack.m_41777_();
                    stack.m_41774_(1);
                    if (stack.m_41613_() <= 0) {
                        entity.m_146870_();
                    } else {
                        itemEntity.m_32045_(stack);
                    }
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).m_41619_()) {
            Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            BlockPos pos = this.m_58899_().m_5484_(outDir, 2);
            Utils.dropStackAtPos(this.f_58857_, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 2;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2;
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getLiftTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        float maxTicks = BottlingProcess.getMaxProcessTick();
        return 1.0f - (BottlingMachineBlockEntity.getTransportTime(maxTicks) + BottlingMachineBlockEntity.getLiftTime(maxTicks)) / maxTicks;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || BlockPos.f_121853_.equals((Object)this.posInMultiblock) && facing.m_122434_().m_122479_())) {
            return this.fluidCap.getAndCast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && facing == (this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_())) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(2, 1, 1).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_()};
        }
        return new Direction[0];
    }

    public static class BottlingMachineInventoryHandler
    implements IItemHandlerModifiable {
        BottlingMachineBlockEntity multiblock;

        public BottlingMachineInventoryHandler(BottlingMachineBlockEntity multiblock) {
            this.multiblock = multiblock;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.multiblock.bottlingProcessQueue.size() < this.multiblock.getProcessQueueMaxLength()) {
                stack = stack.m_41777_();
                float dist = 1.0f;
                BottlingProcess p = null;
                if (this.multiblock.bottlingProcessQueue.size() > 0 && (p = this.multiblock.bottlingProcessQueue.get(this.multiblock.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < this.multiblock.getMinProcessDistance((MultiblockProcess<MultiblockRecipe>)null)) {
                    return stack;
                }
                if (!simulate) {
                    p = new BottlingProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    this.multiblock.bottlingProcessQueue.add(p);
                    this.multiblock.m_6596_();
                    this.multiblock.markContainingBlockForUpdate(null);
                }
                stack.m_41774_(1);
                if (stack.m_41613_() <= 0) {
                    stack = ItemStack.f_41583_;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class BottlingProcess {
        public NonNullList<ItemStack> items;
        public int processTick;
        public int maxProcessTick = BottlingProcess.getMaxProcessTick();
        boolean processFinished = false;

        public BottlingProcess(ItemStack input) {
            this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
            this.items.set(0, (Object)input);
        }

        public boolean processStep(BottlingMachineBlockEntity tile) {
            int energyExtracted = (int)(8.0 * (Double)IEServerConfig.MACHINES.bottlingMachineConfig.energyModifier.get());
            if (tile.energyStorage.extractEnergy(energyExtracted, true) >= energyExtracted) {
                FluidStack fs;
                tile.energyStorage.extractEnergy(energyExtracted, false);
                ++this.processTick;
                float transformationPoint = BottlingMachineBlockEntity.getTransportTime(this.maxProcessTick) + BottlingMachineBlockEntity.getLiftTime(this.maxProcessTick);
                if ((float)this.processTick >= transformationPoint && (float)this.processTick < 1.0f + transformationPoint && !(fs = tile.tanks[0].getFluid()).isEmpty()) {
                    BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe((ItemStack)this.items.get(0), fs);
                    if (recipe != null) {
                        if (recipe.fluidInput.test(tile.tanks[0].getFluid())) {
                            this.items.set(1, (Object)((ItemStack)recipe.getActualItemOutputs(tile).get(0)));
                            tile.tanks[0].drain(recipe.fluidInput.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        }
                    } else {
                        ItemStack ret = FluidUtils.fillFluidContainer((IFluidHandler)tile.tanks[0], (ItemStack)this.items.get(0), ItemStack.f_41583_, null);
                        if (!ret.m_41619_()) {
                            this.items.set(1, (Object)ret);
                        }
                    }
                    if (((ItemStack)this.items.get(1)).m_41619_()) {
                        this.items.set(1, (Object)((ItemStack)this.items.get(0)));
                    }
                    tile.markContainingBlockForUpdate(null);
                }
                if (this.processTick >= this.maxProcessTick) {
                    this.processFinished = true;
                }
                return true;
            }
            return false;
        }

        public static int getMaxProcessTick() {
            return (int)(60.0 * (Double)IEServerConfig.MACHINES.bottlingMachineConfig.timeModifier.get());
        }

        public CompoundTag writeToNBT() {
            CompoundTag nbt = new CompoundTag();
            if (!((ItemStack)this.items.get(0)).m_41619_()) {
                nbt.m_128365_("input", (Tag)((ItemStack)this.items.get(0)).m_41739_(new CompoundTag()));
            }
            if (!((ItemStack)this.items.get(1)).m_41619_()) {
                nbt.m_128365_("output", (Tag)((ItemStack)this.items.get(1)).m_41739_(new CompoundTag()));
            }
            nbt.m_128405_("processTick", this.processTick);
            return nbt;
        }

        public static BottlingProcess readFromNBT(CompoundTag nbt) {
            ItemStack input = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("input"));
            BottlingProcess process = new BottlingProcess(input);
            if (nbt.m_128425_("output", 10)) {
                process.items.set(1, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("output")));
            }
            process.processTick = nbt.m_128451_("processTick");
            return process;
        }
    }
}

