/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AutoWorkbenchBlockEntity
extends PoweredMultiblockBlockEntity<AutoWorkbenchBlockEntity, MultiblockRecipe>
implements IEBlockInterfaces.IInteractionObjectIE<AutoWorkbenchBlockEntity>,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds {
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)17, (Object)ItemStack.f_41583_);
    public int selectedRecipe = -1;
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, this::getOutputPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(16, (IIEInventory)this, 1, true, false)));

    public AutoWorkbenchBlockEntity(BlockEntityType<AutoWorkbenchBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.AUTO_WORKBENCH, 32000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.selectedRecipe = nbt.m_128451_("selectedRecipe");
        if (!descPacket) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("selectedRecipe", this.selectedRecipe);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.m_128425_("recipe", 3)) {
            this.selectedRecipe = message.m_128451_("recipe");
        }
    }

    @Override
    public void tickServer() {
        BlueprintCraftingRecipe recipe;
        super.tickServer();
        if (this.isRSDisabled() || this.f_58857_.m_46467_() % 16L != (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0xF) || ((ItemStack)this.inventory.get(0)).m_41619_()) {
            return;
        }
        BlueprintCraftingRecipe[] recipes = this.getAvailableRecipes();
        if (recipes.length > 0 && this.selectedRecipe >= 0 && this.selectedRecipe < recipes.length && (recipe = recipes[this.selectedRecipe]) != null && !recipe.output.m_41619_()) {
            NonNullList query = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
            for (int i = 0; i < query.size(); ++i) {
                query.set(i, (Object)((ItemStack)this.inventory.get(i + 1)));
            }
            int crafted = recipe.getMaxCrafted((NonNullList<ItemStack>)query);
            if (crafted > 0 && this.addProcessToQueue(new MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, (NonNullList<ItemStack>)NonNullList.m_122779_()), true)) {
                this.addProcessToQueue(new MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, recipe.consumeInputs((NonNullList<ItemStack>)query, 1)), false);
                for (int i = 0; i < query.size(); ++i) {
                    this.inventory.set(i + 1, (Object)((ItemStack)query.get(i)));
                }
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    public BlueprintCraftingRecipe[] getAvailableRecipes() {
        return EngineersBlueprintItem.getRecipes((ItemStack)this.inventory.get(0));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        ImmutableSet highFullBlocks = ImmutableSet.of((Object)new BlockPos(0, 1, 2), (Object)new BlockPos(0, 1, 1));
        if (this.posInMultiblock.m_123342_() == 0 || highFullBlocks.contains(this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        ImmutableSet conveyors = ImmutableSet.of((Object)new BlockPos(1, 1, 1), (Object)new BlockPos(2, 1, 1), (Object)new BlockPos(0, 1, 0), (Object)new BlockPos(1, 1, 0));
        if (conveyors.contains(this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (ImmutableSet.of((Object)new BlockPos(1, 1, 2), (Object)new BlockPos(2, 1, 2)).contains((Object)this.posInMultiblock)) {
            boolean is11 = new BlockPos(2, 1, 2).equals((Object)this.posInMultiblock);
            yMax = 0.8125f;
            if (this.getFacing() == Direction.NORTH) {
                zMin = 0.1875f;
                if (is11) {
                    xMax = 0.875f;
                }
            } else if (this.getFacing() == Direction.SOUTH) {
                zMax = 0.8125f;
                if (is11) {
                    xMin = 0.125f;
                }
            } else if (this.getFacing() == Direction.WEST) {
                xMin = 0.1875f;
                if (is11) {
                    zMin = 0.125f;
                }
            } else if (this.getFacing() == Direction.EAST) {
                xMax = 0.8125f;
                if (is11) {
                    zMax = 0.875f;
                }
            }
        }
        if (new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            yMax = 0.3125f;
            if (this.getFacing() == Direction.NORTH) {
                zMin = 0.25f;
                xMax = 0.875f;
            } else if (this.getFacing() == Direction.SOUTH) {
                zMax = 0.75f;
                xMin = 0.125f;
            } else if (this.getFacing() == Direction.WEST) {
                xMin = 0.25f;
                zMin = 0.125f;
            } else if (this.getFacing() == Direction.EAST) {
                xMax = 0.75f;
                zMax = 0.875f;
            }
        }
        return Shapes.m_83048_((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(0, 1, 2, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).m_41619_()) {
            DirectionalBlockPos outputPos = this.getOutputPos();
            Utils.dropStackAtPos(this.f_58857_, outputPos.position(), output, outputPos.side().m_122424_());
        }
    }

    private DirectionalBlockPos getOutputPos() {
        Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        return new DirectionalBlockPos(this.f_58858_.m_5484_(outDir, 2), outDir.m_122424_());
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.4375f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (new BlockPos(0, 1, 2).equals((Object)this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected BlueprintCraftingRecipe getRecipeForId(ResourceLocation id) {
        return BlueprintCraftingRecipe.recipeList.get(id);
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public AutoWorkbenchBlockEntity getGuiMaster() {
        return (AutoWorkbenchBlockEntity)this.master();
    }

    @Override
    public IEContainerTypes.BEContainer<AutoWorkbenchBlockEntity, ?> getContainerType() {
        return IEContainerTypes.AUTO_WORKBENCH;
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(1, 1, 2).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getFacing().m_122427_()};
        }
        return new Direction[0];
    }
}

