/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractTransformerBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional {
    protected static final int RIGHT_INDEX = 0;
    protected static final int LEFT_INDEX = 1;
    protected WireType leftType;
    protected WireType rightType;
    protected Set<String> acceptableLowerWires = ImmutableSet.of((Object)"LV");

    public AbstractTransformerBlockEntity(BlockEntityType<? extends ImmersiveConnectableBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected boolean canAttach(WireType toAttach, @Nullable WireType atConn, @Nullable WireType other) {
        boolean isOtherHigher;
        if (atConn != null) {
            return false;
        }
        String higherCat = this.getHigherWiretype();
        String attachCat = toAttach.getCategory();
        if (other == null) {
            return higherCat.equals(attachCat) || this.acceptableLowerWires.contains(attachCat);
        }
        boolean isHigher = higherCat.equals(toAttach.getCategory());
        if (isHigher ^ (isOtherHigher = higherCat.equals(other.getCategory()))) {
            if (isHigher) {
                return true;
            }
            return this.acceptableLowerWires.contains(attachCat);
        }
        return false;
    }

    public String getHigherWiretype() {
        return "MV";
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.f_58858_, 0), (Object)new ConnectionPoint(this.f_58858_, 1));
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of((Object)new Connection(this.f_58858_, 1, 0));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        return this.getConnectionOffset(type, here.getIndex() == 0);
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        if (type == null) {
            this.rightType = null;
            this.leftType = null;
        } else {
            switch (attachedPoint.getIndex()) {
                case 1: {
                    this.leftType = null;
                    break;
                }
                case 0: {
                    this.rightType = null;
                }
            }
        }
        this.updateMirrorState();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        switch (target.getIndex()) {
            case 1: {
                this.leftType = cableType;
                break;
            }
            case 0: {
                this.rightType = cableType;
            }
        }
        this.updateMirrorState();
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return switch (target.getIndex()) {
            case 1 -> this.canAttach(cableType, this.leftType, this.rightType);
            case 0 -> this.canAttach(cableType, this.rightType, this.leftType);
            default -> false;
        };
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.leftType != null) {
            nbt.m_128359_("leftType", this.leftType.getUniqueName());
        }
        if (this.rightType != null) {
            nbt.m_128359_("rightType", this.rightType.getUniqueName());
        }
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.leftType = nbt.m_128441_("leftType") ? WireUtils.getWireTypeFromNBT(nbt, "leftType") : null;
        this.rightType = nbt.m_128441_("rightType") ? WireUtils.getWireTypeFromNBT(nbt, "rightType") : null;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    protected abstract Vec3 getConnectionOffset(WireType var1, boolean var2);

    protected void updateMirrorState() {
    }
}

