/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class PoweredMultiblockBlockEntity<T extends PoweredMultiblockBlockEntity<T, R>, R extends MultiblockRecipe>
extends MultiblockPartBlockEntity<T>
implements IIEInventory,
IEBlockInterfaces.IProcessBE,
IEBlockInterfaces.IComparatorOverride {
    public final AveragingEnergyStorage energyStorage;
    protected final MultiblockCapability<IEnergyStorage> energyCap;
    private final MutableInt cachedComparatorValue = new MutableInt(-1);
    public final List<MultiblockProcess<R>> processQueue = new ArrayList<MultiblockProcess<R>>();
    public int tickedProcesses = 0;
    private boolean renderAsActiveClient = false;

    public PoweredMultiblockBlockEntity(IETemplateMultiblock multiblockInstance, int energyCapacity, boolean redstoneControl, BlockEntityType<? extends T> type, BlockPos pos, BlockState state) {
        super(multiblockInstance, type, redstoneControl, pos, state);
        this.energyStorage = new AveragingEnergyStorage(energyCapacity);
        this.energyCap = MultiblockCapability.make(this, be -> be.energyCap, MultiblockPartBlockEntity::master, this.registerEnergyInput(this.energyStorage));
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        if (!descPacket || this.shouldSyncProcessQueue()) {
            ListTag processNBT = nbt.m_128437_("processQueue", 10);
            this.processQueue.clear();
            for (int i = 0; i < processNBT.size(); ++i) {
                CompoundTag tag = processNBT.m_128728_(i);
                if (!tag.m_128441_("recipe")) continue;
                int processTick = tag.m_128451_("process_processTick");
                MultiblockProcess<R> process = this.loadProcessFromNBT(tag);
                if (process == null) continue;
                process.processTick = processTick;
                this.processQueue.add(process);
            }
        }
        if (descPacket) {
            this.renderAsActiveClient = nbt.m_128471_("renderActive");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket || this.shouldSyncProcessQueue()) {
            EnergyHelper.serializeTo(this.energyStorage, nbt);
            ListTag processNBT = new ListTag();
            for (MultiblockProcess<R> process : this.processQueue) {
                processNBT.add((Object)this.writeProcessToNBT(process));
            }
            nbt.m_128365_("processQueue", (Tag)processNBT);
        }
        if (descPacket) {
            nbt.m_128379_("renderActive", this.renderAsActiveClient);
        }
    }

    @Nullable
    protected abstract R getRecipeForId(ResourceLocation var1);

    @Nullable
    protected MultiblockProcess<R> loadProcessFromNBT(CompoundTag tag) {
        String id = tag.m_128461_("recipe");
        R recipe = this.getRecipeForId(new ResourceLocation(id));
        if (recipe != null) {
            if (this.isInWorldProcessingMachine()) {
                return MultiblockProcessInWorld.load(recipe, tag);
            }
            return MultiblockProcessInMachine.load(recipe, tag);
        }
        return null;
    }

    protected CompoundTag writeProcessToNBT(MultiblockProcess<?> process) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("recipe", ((IESerializableRecipe)process.recipe).m_6423_().toString());
        tag.m_128405_("process_processTick", process.processTick);
        process.writeExtraDataToNBT(tag);
        return tag;
    }

    public abstract Set<MultiblockFace> getEnergyPos();

    public boolean isEnergyPos(Direction absoluteFace) {
        return this.getEnergyPos().contains(this.asRelativeFace(absoluteFace));
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction side) {
        if (capability == CapabilityEnergy.ENERGY && (side == null || this.isEnergyPos(side))) {
            return this.energyCap.getAndCast();
        }
        return super.getCapability(capability, side);
    }

    public AABB getRenderBoundingBox() {
        if (!this.isDummy()) {
            BlockPos nullPos = this.getOrigin();
            return new AABB(nullPos, TemplateMultiblock.withSettingsAndOffset(nullPos, new BlockPos((Vec3i)this.structureDimensions.get()), this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing())));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public int getComparatorInputOverride() {
        if (!this.isRedstonePos()) {
            return 0;
        }
        PoweredMultiblockBlockEntity master = (PoweredMultiblockBlockEntity)this.master();
        if (master == null) {
            return 0;
        }
        return master.getComparatorValueOnMaster();
    }

    protected int getComparatorValueOnMaster() {
        return Utils.calcRedstoneFromInventory(this);
    }

    private void syncRenderActive() {
        boolean renderActive = this.shouldRenderAsActive();
        if (this.renderAsActiveClient == renderActive) {
            return;
        }
        this.renderAsActiveClient = renderActive;
        this.updateMasterBlock(null, true);
    }

    @Override
    public void tickServer() {
        this.syncRenderActive();
        if (this.isRSDisabled()) {
            return;
        }
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<MultiblockProcess<R>> processIterator = this.processQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            MultiblockProcess<R> process = processIterator.next();
            if (process.canProcess(this)) {
                process.doProcessTick(this);
                ++this.tickedProcesses;
                this.updateMasterBlock(null, true);
            }
            if (!process.clearProcess) continue;
            processIterator.remove();
        }
        PoweredMultiblockBlockEntity.updateComparators(this, this.getRedstonePos(), this.cachedComparatorValue, this.getComparatorValueOnMaster());
    }

    protected boolean shouldSyncProcessQueue() {
        return true;
    }

    @Nullable
    public abstract IFluidTank[] getInternalTanks();

    @Nullable
    public abstract R findRecipeForInsertion(ItemStack var1);

    @Nullable
    public abstract int[] getOutputSlots();

    @Nullable
    public abstract int[] getOutputTanks();

    public abstract boolean additionalCanProcessCheck(MultiblockProcess<R> var1);

    public abstract void doProcessOutput(ItemStack var1);

    public abstract void doProcessFluidOutput(FluidStack var1);

    public abstract void onProcessFinish(MultiblockProcess<R> var1);

    public abstract int getMaxProcessPerTick();

    public abstract int getProcessQueueMaxLength();

    public abstract float getMinProcessDistance(MultiblockProcess<R> var1);

    public abstract boolean isInWorldProcessingMachine();

    public boolean addProcessToQueue(MultiblockProcess<R> process, boolean simulate) {
        return this.addProcessToQueue(process, simulate, false);
    }

    public boolean addProcessToQueue(MultiblockProcess<R> process, boolean simulate, boolean addToPrevious) {
        if (addToPrevious && process instanceof MultiblockProcessInWorld) {
            MultiblockProcessInWorld newProcess = (MultiblockProcessInWorld)process;
            for (MultiblockProcess<R> curr : this.processQueue) {
                if (!(curr instanceof MultiblockProcessInWorld)) continue;
                MultiblockProcessInWorld existingProcess = (MultiblockProcessInWorld)curr;
                if (!process.recipe.equals(curr.recipe)) continue;
                boolean canStack = true;
                for (ItemStack old : existingProcess.inputItems) {
                    for (ItemStack in : newProcess.inputItems) {
                        if (!ItemStack.m_41746_((ItemStack)old, (ItemStack)in) || !Utils.compareItemNBT(old, in) || old.m_41613_() + in.m_41613_() <= old.m_41741_()) continue;
                        canStack = false;
                        break;
                    }
                    if (canStack) continue;
                    break;
                }
                if (!canStack) continue;
                if (!simulate) {
                    block3: for (ItemStack old : existingProcess.inputItems) {
                        for (ItemStack in : newProcess.inputItems) {
                            if (!ItemStack.m_41746_((ItemStack)old, (ItemStack)in) || !Utils.compareItemNBT(old, in)) continue;
                            old.m_41769_(in.m_41613_());
                            continue block3;
                        }
                    }
                }
                return true;
            }
        }
        if (this.getProcessQueueMaxLength() < 0 || this.processQueue.size() < this.getProcessQueueMaxLength()) {
            float dist = 1.0f;
            MultiblockProcess<R> p = null;
            if (this.processQueue.size() > 0 && (p = this.processQueue.get(this.processQueue.size() - 1)) != null) {
                dist = (float)p.processTick / (float)p.maxTicks;
            }
            if (p != null && dist < this.getMinProcessDistance(p)) {
                return false;
            }
            if (!simulate) {
                this.processQueue.add(process);
            }
            this.markContainingBlockForUpdate(null);
            this.markChunkDirty();
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public int[] getCurrentProcessesStep() {
        PoweredMultiblockBlockEntity master = (PoweredMultiblockBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        int[] ia = new int[this.processQueue.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.processQueue.get((int)i).processTick;
        }
        return ia;
    }

    @Override
    @Nonnull
    public int[] getCurrentProcessesMax() {
        PoweredMultiblockBlockEntity master = (PoweredMultiblockBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        int[] ia = new int[this.processQueue.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.processQueue.get((int)i).maxTicks;
        }
        return ia;
    }

    public final boolean shouldRenderAsActive() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return this.shouldRenderAsActiveImpl();
        }
        return this.renderAsActiveClient;
    }

    protected boolean shouldRenderAsActiveImpl() {
        return this.energyStorage.getEnergyStored() > 0 && !this.isRSDisabled() && !this.processQueue.isEmpty();
    }

    protected final MultiblockFace asRelativeFace(Direction absoluteFace) {
        return new MultiblockFace(this.posInMultiblock, RelativeBlockFace.from(this.getFacing().m_122424_(), this.getIsMirrored(), absoluteFace));
    }

    protected record MultiblockFace(BlockPos posInMultiblock, RelativeBlockFace face) {
        public MultiblockFace(int x, int y, int z, RelativeBlockFace face) {
            this(new BlockPos(x, y, z), face);
        }
    }

    public static class MultiblockInventoryHandler_DirectProcessing<T extends PoweredMultiblockBlockEntity<T, R>, R extends MultiblockRecipe>
    implements IItemHandlerModifiable {
        T multiblock;
        float transformationPoint = 0.5f;
        boolean doProcessStacking = false;

        public MultiblockInventoryHandler_DirectProcessing(T multiblock) {
            this.multiblock = multiblock;
        }

        public MultiblockInventoryHandler_DirectProcessing<T, R> setTransformationPoint(float point) {
            this.transformationPoint = point;
            return this;
        }

        public MultiblockInventoryHandler_DirectProcessing<T, R> setProcessStacking(boolean stacking) {
            this.doProcessStacking = stacking;
            return this;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            Object recipe = ((PoweredMultiblockBlockEntity)this.multiblock).findRecipeForInsertion(stack = stack.m_41777_());
            if (recipe == null) {
                return stack;
            }
            ItemStack displayStack = recipe.getDisplayStack(stack);
            if (((PoweredMultiblockBlockEntity)this.multiblock).addProcessToQueue(new MultiblockProcessInWorld(recipe, this.transformationPoint, Utils.createNonNullItemStackListFromItemStack(displayStack)), simulate, this.doProcessStacking)) {
                ((IEBaseBlockEntity)this.multiblock).m_6596_();
                ((IEBaseBlockEntity)this.multiblock).markContainingBlockForUpdate(null);
                stack.m_41774_(displayStack.m_41613_());
                if (stack.m_41613_() <= 0) {
                    stack = ItemStack.f_41583_;
                }
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }
    }
}

