/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;

public abstract class IEMultiblockBlock<T extends MultiblockPartBlockEntity<? super T>>
extends IEEntityBlock<T> {
    public IEMultiblockBlock(BlockBehaviour.Properties props, MultiblockBEType<T> entityType) {
        super(entityType, props);
        this.setMobility(PushReaction.BLOCK);
        this.lightOpacity = 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IEProperties.FACING_HORIZONTAL, IEProperties.MULTIBLOCKSLAVE});
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof IEBaseBlockEntity) {
                IEBaseBlockEntity ieBaseBE = (IEBaseBlockEntity)blockEntity;
                ieBaseBE.setOverrideState(state);
            }
            if (blockEntity instanceof MultiblockPartBlockEntity) {
                MultiblockPartBlockEntity multiblockBE = (MultiblockPartBlockEntity)blockEntity;
                super.m_6810_(state, world, pos, newState, isMoving);
                multiblockBE.disassemble();
                return;
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof MultiblockPartBlockEntity) {
            return Utils.getPickBlock(((MultiblockPartBlockEntity)te).getOriginalBlock(), target, player);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }
}

