/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public class IEEntityBlock<T extends BlockEntity>
extends IEBaseBlock
implements IEBlockInterfaces.IColouredBlock,
EntityBlock {
    private boolean hasColours = false;
    private final BiFunction<BlockPos, BlockState, T> makeEntity;
    private BEClassInspectedData classData;
    private static final List<BooleanProperty> DEFAULT_OFF = ImmutableList.of((Object)IEProperties.MULTIBLOCKSLAVE, (Object)IEProperties.ACTIVE, (Object)IEProperties.MIRRORED);

    public IEEntityBlock(BiFunction<BlockPos, BlockState, T> makeEntity, BlockBehaviour.Properties blockProps) {
        super(blockProps);
        this.makeEntity = makeEntity;
    }

    public IEEntityBlock(RegistryObject<BlockEntityType<T>> tileType, BlockBehaviour.Properties blockProps) {
        this((BlockPos bp, BlockState state) -> ((BlockEntityType)tileType.get()).m_155264_(bp, state), blockProps);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return (BlockEntity)this.makeEntity.apply(pPos, pState);
    }

    @Nullable
    public <T2 extends BlockEntity> BlockEntityTicker<T2> m_142354_(Level world, BlockState state, BlockEntityType<T2> type) {
        MultiblockBEType multiBEType;
        BlockEntityTicker baseTicker = this.getClassData().makeBaseTicker(world.f_46443_);
        BiFunction<BlockPos, BlockState, T> biFunction = this.makeEntity;
        if (biFunction instanceof MultiblockBEType && type != (multiBEType = (MultiblockBEType)biFunction).master()) {
            return null;
        }
        return baseTicker;
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        if (ret.m_61138_((Property)IEProperties.FACING_ALL)) {
            ret = (BlockState)ret.m_61124_((Property)IEProperties.FACING_ALL, (Comparable)this.getDefaultFacing());
        } else if (ret.m_61138_((Property)IEProperties.FACING_HORIZONTAL)) {
            ret = (BlockState)ret.m_61124_((Property)IEProperties.FACING_HORIZONTAL, (Comparable)this.getDefaultFacing());
        }
        for (BooleanProperty defaultOff : DEFAULT_OFF) {
            if (!ret.m_61138_((Property)defaultOff)) continue;
            ret = (BlockState)ret.m_61124_((Property)defaultOff, (Comparable)Boolean.valueOf(false));
        }
        return ret;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (state.m_60734_() != newState.m_60734_()) {
            if (tile instanceof IEBaseBlockEntity) {
                ((IEBaseBlockEntity)tile).setOverrideState(state);
            }
            if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
                ((IEBlockInterfaces.IHasDummyBlocks)tile).breakDummies(pos, state);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity tile, ItemStack stack) {
        Collection<ItemStack> stacks;
        if (tile instanceof IEBlockInterfaces.IAdditionalDrops && (stacks = ((IEBlockInterfaces.IAdditionalDrops)tile).getExtraDrops(player, state)) != null && !stacks.isEmpty()) {
            for (ItemStack s : stacks) {
                if (s.m_41619_()) continue;
                IEEntityBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)s);
            }
        }
        super.m_6240_(world, player, pos, state, tile, stack);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IEntityProof) {
            return ((IEBlockInterfaces.IEntityProof)tile).canEntityDestroy(entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack s;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IBlockEntityDrop && target instanceof BlockHitResult && !(s = ((IEBlockInterfaces.IBlockEntityDrop)tile).getPickBlock(player, world.m_8055_(pos), target)).m_41619_()) {
            return s;
        }
        Item item = this.m_5456_();
        return item == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, 1);
    }

    @Override
    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, worldIn, pos, eventID, eventParam);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity != null && tileentity.m_7531_(eventID, eventParam);
    }

    protected Direction getDefaultFacing() {
        return Direction.NORTH;
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity tile = world.m_7702_(pos);
        Player placer = context.m_43723_();
        Direction side = context.m_43719_();
        float hitX = (float)context.m_43720_().f_82479_ - (float)pos.m_123341_();
        float hitY = (float)context.m_43720_().f_82480_ - (float)pos.m_123342_();
        float hitZ = (float)context.m_43720_().f_82481_ - (float)pos.m_123343_();
        ItemStack stack = context.m_43722_();
        if (tile instanceof IEBlockInterfaces.IDirectionalBE) {
            Direction f = ((IEBlockInterfaces.IDirectionalBE)tile).getFacingForPlacement(context);
            ((IEBlockInterfaces.IDirectionalBE)tile).setFacing(f);
            if (tile instanceof IEBlockInterfaces.IAdvancedDirectionalBE) {
                ((IEBlockInterfaces.IAdvancedDirectionalBE)tile).onDirectionalPlacement(side, hitX, hitY, hitZ, (LivingEntity)placer);
            }
        }
        if (tile instanceof IEBlockInterfaces.IReadOnPlacement) {
            ((IEBlockInterfaces.IReadOnPlacement)tile).readOnPlacement((LivingEntity)placer, stack);
        }
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            ((IEBlockInterfaces.IHasDummyBlocks)tile).placeDummies(context, state);
        }
        if (tile instanceof IEBlockInterfaces.IPlacementInteraction) {
            ((IEBlockInterfaces.IPlacementInteraction)tile).onBEPlaced(world, pos, state, side, hitX, hitY, hitZ, (LivingEntity)placer, stack);
        }
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        BlockEntity tile = w.m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IHammerInteraction) {
            boolean b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hand, hit.m_82450_());
            if (b) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.hammerUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        InteractionResult teResult;
        BlockEntity tile = w.m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IScrewdriverInteraction && (teResult = ((IEBlockInterfaces.IScrewdriverInteraction)tile).screwdriverUseSide(side, player, hand, hit.m_82450_())) != InteractionResult.PASS) {
            return teResult;
        }
        return super.screwdriverUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean b;
        InteractionResult superResult = super.m_6227_(state, world, pos, player, hand, hit);
        if (superResult.m_19077_()) {
            return superResult;
        }
        Direction side = hit.m_82434_();
        float hitX = (float)hit.m_82450_().f_82479_ - (float)pos.m_123341_();
        float hitY = (float)hit.m_82450_().f_82480_ - (float)pos.m_123342_();
        float hitZ = (float)hit.m_82450_().f_82481_ - (float)pos.m_123343_();
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IDirectionalBE && Utils.isHammer(heldItem) && ((IEBlockInterfaces.IDirectionalBE)tile).canHammerRotate(side, hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos)), (LivingEntity)player) && !world.f_46443_) {
            Direction f;
            Direction oldF = f = ((IEBlockInterfaces.IDirectionalBE)tile).getFacing();
            PlacementLimitation limit = ((IEBlockInterfaces.IDirectionalBE)tile).getFacingLimitation();
            switch (limit) {
                case SIDE_CLICKED: {
                    f = DirectionUtils.VALUES[Math.floorMod(f.ordinal() + (player.m_6144_() ? -1 : 1), DirectionUtils.VALUES.length)];
                    break;
                }
                case PISTON_LIKE: {
                    f = player.m_6144_() != (side.m_122421_() == Direction.AxisDirection.NEGATIVE) ? DirectionUtils.rotateAround(f, side.m_122434_()).m_122424_() : DirectionUtils.rotateAround(f, side.m_122434_());
                    break;
                }
                case HORIZONTAL: 
                case HORIZONTAL_PREFER_SIDE: 
                case HORIZONTAL_QUADRANT: 
                case HORIZONTAL_AXIS: {
                    f = player.m_6144_() != side.equals((Object)Direction.DOWN) ? f.m_122428_() : f.m_122427_();
                }
            }
            ((IEBlockInterfaces.IDirectionalBE)tile).setFacing(f);
            ((IEBlockInterfaces.IDirectionalBE)tile).afterRotation(oldF, f);
            tile.m_6596_();
            world.m_7260_(pos, state, state, 3);
            world.m_7696_(tile.m_58899_(), tile.m_58900_().m_60734_(), 255, 0);
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof IEBlockInterfaces.IPlayerInteraction && (b = ((IEBlockInterfaces.IPlayerInteraction)tile).interact(side, player, hand, heldItem, hitX, hitY, hitZ))) {
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof IEBlockInterfaces.IInteractionObjectIE && hand == InteractionHand.MAIN_HAND && !player.m_6144_()) {
            IEBlockInterfaces.IInteractionObjectIE interaction = (IEBlockInterfaces.IInteractionObjectIE)tile;
            if ((interaction = (IEBlockInterfaces.IInteractionObjectIE)interaction.getGuiMaster()) != null && interaction.canUseGui(player) && !world.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)interaction, (BlockPos)((BlockEntity)interaction).m_58899_());
            }
            return InteractionResult.SUCCESS;
        }
        return superResult;
    }

    @Nullable
    private Property<Direction> findFacingProperty(BlockState state) {
        if (state.m_61138_((Property)IEProperties.FACING_ALL)) {
            return IEProperties.FACING_ALL;
        }
        if (state.m_61138_((Property)IEProperties.FACING_HORIZONTAL)) {
            return IEProperties.FACING_HORIZONTAL;
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.m_61143_(facingProp);
            Direction newDirection = rot.m_55954_(currentDirection);
            return (BlockState)state.m_61124_(facingProp, (Comparable)newDirection);
        }
        return super.m_6843_(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (state.m_61138_((Property)IEProperties.MIRRORED) && this.canRotate() && mirrorIn == Mirror.LEFT_RIGHT) {
            return (BlockState)state.m_61124_((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)IEProperties.MIRRORED) == false));
        }
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.m_61143_(facingProp);
            Direction newDirection = mirrorIn.m_54848_(currentDirection);
            return (BlockState)state.m_61124_(facingProp, (Comparable)newDirection);
        }
        return super.m_6943_(state, mirrorIn);
    }

    protected boolean canRotate() {
        return !this.m_49965_().m_61092_().contains(IEProperties.MULTIBLOCKSLAVE);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile;
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof IEBaseBlockEntity) {
            ((IEBaseBlockEntity)tile).onNeighborBlockChange(fromPos);
        }
    }

    public IEEntityBlock setHasColours() {
        this.hasColours = true;
        return this;
    }

    @Override
    public boolean hasCustomBlockColours() {
        return this.hasColours;
    }

    @Override
    public int getRenderColour(BlockState state, @Nullable BlockGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity tile;
        if (worldIn != null && pos != null && (tile = worldIn.m_7702_(pos)) instanceof IEBlockInterfaces.IColouredBE) {
            return ((IEBlockInterfaces.IColouredBE)tile).getRenderColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity te;
        if (state.m_60734_() == this && (te = world.m_7702_(pos)) instanceof IEBlockInterfaces.ISelectionBounds) {
            return ((IEBlockInterfaces.ISelectionBounds)te).getSelectionShape(context);
        }
        return super.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.getClassData().customCollisionBounds()) {
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof IEBlockInterfaces.ICollisionBounds) {
                IEBlockInterfaces.ICollisionBounds collisionBounds = (IEBlockInterfaces.ICollisionBounds)te;
                return collisionBounds.getCollisionShape(context);
            }
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, world, pos, context);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te;
        if (world.m_8055_(pos).m_60734_() == this && (te = world.m_7702_(pos)) instanceof IEBlockInterfaces.ISelectionBounds) {
            return ((IEBlockInterfaces.ISelectionBounds)te).getSelectionShape(null);
        }
        return super.m_6079_(state, world, pos);
    }

    public boolean m_7278_(BlockState state) {
        return this.getClassData().hasComparatorOutput;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IEBlockInterfaces.IComparatorOverride) {
            IEBlockInterfaces.IComparatorOverride compOverride = (IEBlockInterfaces.IComparatorOverride)te;
            return compOverride.getComparatorInputOverride();
        }
        return 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            IEBlockInterfaces.IRedstoneOutput rsOutput = (IEBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.getWeakRSOutput(side);
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            IEBlockInterfaces.IRedstoneOutput rsOutput = (IEBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.getStrongRSOutput(side);
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return this.getClassData().emitsRedstone();
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            IEBlockInterfaces.IRedstoneOutput rsOutput = (IEBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.canConnectRedstone(side);
        }
        return false;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IEBaseBlockEntity) {
            ((IEBaseBlockEntity)te).onEntityCollision(world, entity);
        }
    }

    public static boolean areAllReplaceable(BlockPos start, BlockPos end, BlockPlaceContext context) {
        Level w = context.m_43725_();
        return BlockPos.m_121990_((BlockPos)start, (BlockPos)end).allMatch(pos -> {
            BlockPlaceContext subContext = BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)pos, (Direction)context.m_43719_());
            return w.m_8055_(pos).m_60629_(subContext);
        });
    }

    private BEClassInspectedData getClassData() {
        if (this.classData == null) {
            BlockEntity tempBE = (BlockEntity)this.makeEntity.apply(BlockPos.f_121853_, this.getInitDefaultState());
            this.classData = new BEClassInspectedData(tempBE instanceof IEServerTickableBE, tempBE instanceof IEClientTickableBE, tempBE instanceof IEBlockInterfaces.IComparatorOverride, tempBE instanceof IEBlockInterfaces.IRedstoneOutput, tempBE instanceof IEBlockInterfaces.ICollisionBounds);
        }
        return this.classData;
    }

    private record BEClassInspectedData(boolean serverTicking, boolean clientTicking, boolean hasComparatorOutput, boolean emitsRedstone, boolean customCollisionBounds) {
        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> makeBaseTicker(boolean isClient) {
            if (this.serverTicking && !isClient) {
                return IEServerTickableBE.makeTicker();
            }
            if (this.clientTicking && isClient) {
                return IEClientTickableBE.makeTicker();
            }
            return null;
        }
    }
}

