/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class BlockItemIE
extends BlockItem {
    private int burnTime;

    public BlockItemIE(Block b, Item.Properties props) {
        super(b, props);
    }

    public BlockItemIE(Block b) {
        this(b, new Item.Properties().m_41491_(ImmersiveEngineering.ITEM_GROUP));
    }

    public String m_5671_(ItemStack stack) {
        return this.m_40614_().m_7705_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        FluidStack fs;
        IIEBlock ieBlock;
        Block block = this.m_40614_();
        if (block instanceof IIEBlock && (ieBlock = (IIEBlock)block).hasFlavour()) {
            String flavourKey = "desc.immersiveengineering.flavour." + ieBlock.getNameForFlavour();
            tooltip.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent(flavourKey), ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, advanced);
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            tooltip.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent("desc.immersiveengineering.info.energyStored", new Object[]{ItemNBTHelper.getInt(stack, "energyStorage")}), ChatFormatting.GRAY));
        }
        if (ItemNBTHelper.hasKey(stack, "tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundTag)ItemNBTHelper.getTagCompound(stack, "tank"))) != null) {
            tooltip.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent("desc.immersiveengineering.info.fluidStored", new Object[]{fs.getDisplayName(), fs.getAmount()}), ChatFormatting.GRAY));
        }
    }

    public BlockItemIE setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
        return this.burnTime;
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState newState) {
        Block b = newState.m_60734_();
        if (b instanceof IEBaseBlock) {
            IEBaseBlock ieBlock = (IEBaseBlock)b;
            if (!ieBlock.canIEBlockBePlaced(newState, context)) {
                return false;
            }
            boolean ret = super.m_7429_(context, newState);
            if (ret) {
                ieBlock.onIEBlockPlacedBy(context, newState);
            }
            return ret;
        }
        return super.m_7429_(context, newState);
    }

    protected boolean m_7274_(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        if (!state.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE)) {
            return super.m_7274_(pos, worldIn, player, stack, state);
        }
        return false;
    }

    public static class BlockItemIENoInventory
    extends BlockItemIE {
        public BlockItemIENoInventory(Block b, Item.Properties props) {
            super(b, props);
        }

        @Nullable
        public CompoundTag getShareTag(ItemStack stack) {
            CompoundTag ret = super.getShareTag(stack);
            if (ret != null) {
                ret = ret.m_6426_();
                ret.m_128473_("inventory");
            }
            return ret;
        }
    }
}

