/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.mixin.accessors.client.PlayerControllerAccess;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    private static final float[][] quadCoords = new float[4][3];
    private static final int[][] neighbourBrightness = new int[2][6];
    private static final float[][] normalizationFactors = new float[2][8];

    public static void renderModelTESRFancy(List<BakedQuad> quads, VertexConsumer renderer, Level world, BlockPos pos, boolean useCached, int color, int light) {
        if (((Boolean)IEClientConfig.disableFancyTESR.get()).booleanValue()) {
            RenderUtils.renderModelTESRFast(quads, renderer, new PoseStack(), world.m_45524_(pos, 0), color);
        } else {
            if (!useCached) {
                for (Direction f : DirectionUtils.VALUES) {
                    int val = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos.m_142300_(f));
                    RenderUtils.neighbourBrightness[0][f.m_122411_()] = val >> 16 & 0xFF;
                    RenderUtils.neighbourBrightness[1][f.m_122411_()] = val & 0xFF;
                }
                for (int type = 0; type < 2; ++type) {
                    for (int i = 0; i < 8; ++i) {
                        float sSquared = 0.0f;
                        sSquared = (i & 1) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][5], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][4], 255.0f));
                        sSquared = (i & 2) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][1], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][0], 255.0f));
                        sSquared = (i & 4) != 0 ? (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][3], 255.0f)) : (sSquared += RenderUtils.scaledSquared(neighbourBrightness[type][2], 255.0f));
                        RenderUtils.normalizationFactors[type][i] = (float)Math.sqrt(sSquared);
                    }
                }
            }
            int[] rgba = new int[]{255, 255, 255, 255};
            if (color >= 0) {
                rgba[0] = color >> 16 & 0xFF;
                rgba[1] = color >> 8 & 0xFF;
                rgba[2] = color & 0xFF;
            }
            for (BakedQuad quad : quads) {
                int[] vData = quad.m_111303_();
                VertexFormat format = DefaultVertexFormat.f_85811_;
                int size = format.m_86017_();
                int uvOffset = ClientUtils.findTextureOffset(format);
                int posOffset = ClientUtils.findPositionOffset(format);
                for (int i = 0; i < 4; ++i) {
                    RenderUtils.quadCoords[i][0] = Float.intBitsToFloat(vData[size * i + posOffset]);
                    RenderUtils.quadCoords[i][1] = Float.intBitsToFloat(vData[size * i + posOffset + 1]);
                    RenderUtils.quadCoords[i][2] = Float.intBitsToFloat(vData[size * i + posOffset + 2]);
                }
                Vec3 side1 = new Vec3((double)(quadCoords[1][0] - quadCoords[3][0]), (double)(quadCoords[1][1] - quadCoords[3][1]), (double)(quadCoords[1][2] - quadCoords[3][2]));
                Vec3 side2 = new Vec3((double)(quadCoords[2][0] - quadCoords[0][0]), (double)(quadCoords[2][1] - quadCoords[0][1]), (double)(quadCoords[2][2] - quadCoords[0][2]));
                Vec3 normal = side1.m_82537_(side2);
                normal = normal.m_82541_();
                int l1 = RenderUtils.getLightValue(neighbourBrightness[1], normalizationFactors[1], light & 0xFF, normal);
                int l2 = RenderUtils.getLightValue(neighbourBrightness[0], normalizationFactors[0], light >> 16 & 0xFF, normal);
                for (int i = 0; i < 4; ++i) {
                    renderer.m_5483_((double)quadCoords[i][0], (double)quadCoords[i][1], (double)quadCoords[i][2]).m_6122_(rgba[0], rgba[1], rgba[2], rgba[3]).m_7421_(Float.intBitsToFloat(vData[size * i + uvOffset]), Float.intBitsToFloat(vData[size * i + uvOffset + 1])).m_86008_(OverlayTexture.f_118083_).m_7120_(l1, l2).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
                }
            }
        }
    }

    private static int getLightValue(int[] neighbourBrightness, float[] normalizationFactors, int localBrightness, Vec3 normal) {
        double sideBrightness;
        byte type = 0;
        if (normal.f_82479_ > 0.0) {
            sideBrightness = normal.f_82479_ * (double)neighbourBrightness[5];
            type = (byte)(type | 1);
        } else {
            sideBrightness = -normal.f_82479_ * (double)neighbourBrightness[4];
        }
        if (normal.f_82480_ > 0.0) {
            sideBrightness += normal.f_82480_ * (double)neighbourBrightness[1];
            type = (byte)(type | 2);
        } else {
            sideBrightness += -normal.f_82480_ * (double)neighbourBrightness[0];
        }
        if (normal.f_82481_ > 0.0) {
            sideBrightness += normal.f_82481_ * (double)neighbourBrightness[3];
            type = (byte)(type | 4);
        } else {
            sideBrightness += -normal.f_82481_ * (double)neighbourBrightness[2];
        }
        return (int)(((double)localBrightness + sideBrightness / (double)normalizationFactors[type]) / 2.0);
    }

    private static float scaledSquared(int val, float scale) {
        return (float)val / scale * ((float)val / scale);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, int light, int overlay) {
        RenderUtils.renderModelTESRFast(quads, renderer, transform, -1, light, overlay);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, int color, int light, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (color >= 0) {
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
        }
        for (BakedQuad quad : quads) {
            renderer.m_85987_(transform.m_85850_(), quad, red, green, blue, light, overlay);
        }
    }

    public static void drawBlockDamageTexture(PoseStack matrix, MultiBufferSource buffers, Level world, Collection<BlockPos> blocks) {
        MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
        int progress = (int)(((PlayerControllerAccess)controller).getDestroyProgress() * 10.0f) - 1;
        if (progress < 0 || progress >= ModelBakery.f_119229_.size()) {
            return;
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
        for (BlockPos blockpos : blocks) {
            BlockState iblockstate;
            boolean hasBreak;
            matrix.m_85836_();
            matrix.m_85837_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            VertexConsumer worldRendererIn = buffers.m_6299_((RenderType)ModelBakery.f_119229_.get(progress));
            worldRendererIn = new SheetedDecalTextureGenerator(worldRendererIn, matrix.m_85850_().m_85861_(), matrix.m_85850_().m_85864_());
            Block block = world.m_8055_(blockpos).m_60734_();
            boolean bl = hasBreak = block instanceof ChestBlock || block instanceof EnderChestBlock || block instanceof SignBlock || block instanceof SkullBlock;
            if (!hasBreak && (iblockstate = world.m_8055_(blockpos)).m_60767_() != Material.f_76296_) {
                blockrendererdispatcher.m_110918_(iblockstate, blockpos, (BlockAndTintGetter)world, matrix, worldRendererIn);
            }
            matrix.m_85849_();
        }
    }

    public static void renderBox(VertexConsumer wr, PoseStack m, float x0, float y0, float z0, float x1, float y1, float z1) {
        Matrix4f transform = m.m_85850_().m_85861_();
        wr.m_85982_(transform, x0, y0, z1).m_5752_();
        wr.m_85982_(transform, x1, y0, z1).m_5752_();
        wr.m_85982_(transform, x1, y1, z1).m_5752_();
        wr.m_85982_(transform, x0, y1, z1).m_5752_();
        wr.m_85982_(transform, x0, y1, z0).m_5752_();
        wr.m_85982_(transform, x1, y1, z0).m_5752_();
        wr.m_85982_(transform, x1, y0, z0).m_5752_();
        wr.m_85982_(transform, x0, y0, z0).m_5752_();
        wr.m_85982_(transform, x0, y0, z0).m_5752_();
        wr.m_85982_(transform, x1, y0, z0).m_5752_();
        wr.m_85982_(transform, x1, y0, z1).m_5752_();
        wr.m_85982_(transform, x0, y0, z1).m_5752_();
        wr.m_85982_(transform, x0, y1, z1).m_5752_();
        wr.m_85982_(transform, x1, y1, z1).m_5752_();
        wr.m_85982_(transform, x1, y1, z0).m_5752_();
        wr.m_85982_(transform, x0, y1, z0).m_5752_();
        wr.m_85982_(transform, x0, y0, z0).m_5752_();
        wr.m_85982_(transform, x0, y0, z1).m_5752_();
        wr.m_85982_(transform, x0, y1, z1).m_5752_();
        wr.m_85982_(transform, x0, y1, z0).m_5752_();
        wr.m_85982_(transform, x1, y1, z0).m_5752_();
        wr.m_85982_(transform, x1, y1, z1).m_5752_();
        wr.m_85982_(transform, x1, y0, z1).m_5752_();
        wr.m_85982_(transform, x1, y0, z0).m_5752_();
    }

    public static void renderTexturedBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite tex, boolean yForV) {
        float minU = tex.m_118367_((double)(x0 * 16.0f));
        float maxU = tex.m_118367_((double)(x1 * 16.0f));
        float minV = tex.m_118393_((double)((yForV ? y1 : z0) * 16.0f));
        float maxV = tex.m_118393_((double)((yForV ? y0 : z1) * 16.0f));
        RenderUtils.renderTexturedBox(wr, stack, x0, y0, z0, x1, y1, z1, minU, minV, maxU, maxV, 0xF000F0);
    }

    public static void renderTexturedBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int light) {
        float normalX = 0.0f;
        float normalY = 0.0f;
        float normalZ = 1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u0, v1, normalX, normalY, normalZ, light);
        normalZ = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v1, normalX, normalY, normalZ, light);
        normalZ = 0.0f;
        normalY = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u0, v1, normalX, normalY, normalZ, light);
        normalY = 1.0f;
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ, light);
        normalY = 0.0f;
        normalX = -1.0f;
        RenderUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y0, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ, light);
        normalX = 1.0f;
        RenderUtils.putVertex(wr, stack, x1, y1, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ, light);
        RenderUtils.putVertex(wr, stack, x1, y0, z0, u0, v1, normalX, normalY, normalZ, light);
    }

    private static void putVertex(VertexConsumer b, PoseStack mat, float x, float y, float z, float u, float v, float nX, float nY, float nZ, int light) {
        b.m_85982_(mat.m_85850_().m_85861_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat.m_85850_().m_85864_(), nX, nY, nZ).m_5752_();
    }
}

