/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.metal.SheetmetalTankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.fluids.FluidStack;

public class SheetmetalTankRenderer
extends IEBlockEntityRenderer<SheetmetalTankBlockEntity> {
    public void render(SheetmetalTankBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.formed || tile.isDummy() || !tile.getLevelNonnull().m_46805_(tile.m_58899_())) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        FluidStack fs = tile.tank.getFluid();
        matrixStack.m_85837_(0.0, 3.5, 0.0);
        float baseScale = 0.0625f;
        matrixStack.m_85841_(baseScale, -baseScale, baseScale);
        float xx = -0.5f;
        float zz = 1.496f;
        xx /= baseScale;
        zz /= baseScale;
        for (int i = 0; i < 4; ++i) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)xx, 0.0, (double)zz);
            Matrix4f mat = matrixStack.m_85850_().m_85861_();
            VertexConsumer builder = bufferIn.m_6299_(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
            builder.m_85982_(mat, -4.0f, -4.0f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
            builder.m_85982_(mat, -4.0f, 20.0f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
            builder.m_85982_(mat, 20.0f, 20.0f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
            builder.m_85982_(mat, 20.0f, -4.0f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
            if (!fs.isEmpty()) {
                float h = (float)fs.getAmount() / (float)tile.tank.getCapacity();
                matrixStack.m_85837_(0.0, 0.0, (double)0.004f);
                GuiHelper.drawRepeatedFluidSprite(bufferIn.m_6299_(RenderType.m_110451_()), matrixStack, fs, 0.0f, 0.0f + (1.0f - h) * 16.0f, 16.0f, h * 16.0f);
            }
            matrixStack.m_85849_();
            matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
        }
        matrixStack.m_85849_();
    }
}

