/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.blocks.metal.AutoWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class AutoWorkbenchRenderer
extends IEBlockEntityRenderer<AutoWorkbenchBlockEntity> {
    public static final String NAME = "auto_workbench_animated";
    public static DynamicModel DYNAMIC;
    public static HashMap<BlueprintCraftingRecipe, BlueprintLines> blueprintCache;

    public void render(AutoWorkbenchBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!blockEntity.formed || blockEntity.isDummy() || !blockEntity.getLevelNonnull().m_46805_(blockEntity.m_58899_())) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = blockEntity.m_58899_();
        BlockState state = blockEntity.getLevelNonnull().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.AUTO_WORKBENCH.get()) {
            return;
        }
        BakedModel model = DYNAMIC.get();
        float[][] itemDisplays = new float[blockEntity.processQueue.size()][];
        float drill = 0.0f;
        float lift = 0.0f;
        float press = 0.0f;
        float liftPress = 0.0f;
        for (int i = 0; i < itemDisplays.length; ++i) {
            float processTimer;
            MultiblockProcess process = (MultiblockProcess)blockEntity.processQueue.get(i);
            if (process == null || process.processTick <= 0 || process.processTick == process.maxTicks || (processTimer = (float)process.processTick / (float)process.maxTicks * 180.0f) <= 9.0f) continue;
            float itemX = -1.0f;
            float itemY = -0.34375f;
            float itemZ = -0.9375f;
            float itemAngle = 90.0f;
            if (processTimer <= 24.0f) {
                itemAngle = 67.5f;
                if (processTimer <= 19.0f) {
                    itemZ = (float)((double)itemZ + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.5f)));
                    itemY = (float)((double)itemY + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.21875f)));
                } else {
                    itemZ += (24.0f - processTimer) / 5.0f * 0.25f;
                    itemY += (24.0f - processTimer) / 5.0f * 0.25f;
                }
            } else if (processTimer <= 40.0f) {
                itemX += (processTimer - 24.0f) / 16.0f;
            } else if (processTimer <= 100.0f) {
                itemX += 1.0f;
                float drillStep = 0.0f;
                if (processTimer <= 60.0f) {
                    lift = (processTimer - 40.0f) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (60.0f - processTimer) * 4.0f;
                } else if (processTimer <= 80.0f) {
                    lift = 0.3125f;
                    drillStep = 4.0f;
                } else {
                    lift = (100.0f - processTimer) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (processTimer - 80.0f) * 4.0f;
                }
                if (drillStep > 0.0f) {
                    drill = processTimer % drillStep / drillStep * 360.0f;
                }
                itemY = (float)((double)itemY + Math.max(0.0, (double)lift - 0.0625));
            } else if (processTimer <= 116.0f) {
                itemX += 1.0f;
                itemZ += (processTimer - 100.0f) / 16.0f;
            } else if (processTimer <= 132.0f) {
                itemX += 1.0f + (processTimer - 116.0f) / 16.0f;
                itemZ += 1.0f;
            } else if (processTimer <= 172.0f) {
                itemX += 2.0f;
                itemZ += 1.0f;
                press = processTimer <= 142.0f ? (processTimer - 132.0f) / 10.0f : (processTimer <= 162.0f ? 1.0f : (172.0f - processTimer) / 10.0f);
                liftPress = press * 0.0625f;
                itemY += liftPress;
            } else if (processTimer <= 180.0f) {
                itemX += 2.0f + (processTimer - 172.0f) / 16.0f;
                itemZ += 1.0f;
            }
            itemDisplays[i] = new float[]{processTimer, itemX, itemY, itemZ, itemAngle};
        }
        matrixStack.m_85836_();
        bufferIn = BERenderUtils.mirror(blockEntity, matrixStack, bufferIn);
        Direction facing = blockEntity.getFacing();
        if (blockEntity.getIsMirrored()) {
            if (facing.m_122434_() == Direction.Axis.Z) {
                matrixStack.m_85837_(-1.0, 0.0, 0.0);
            } else {
                matrixStack.m_85837_(0.0, 0.0, -1.0);
            }
        }
        AutoWorkbenchRenderer.rotateForFacing(matrixStack, facing);
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85836_();
        ItemStack blueprintStack = (ItemStack)blockEntity.inventory.get(0);
        if (!blueprintStack.m_41619_()) {
            AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "blueprint");
        }
        matrixStack.m_85837_(0.0, (double)lift, 0.0);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.m_85837_(0.0, (double)(-lift), 0.0);
        float tx = 0.0f;
        float tz = -0.9375f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)tx, 0.0, (double)tz);
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), drill, true));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "drill");
        matrixStack.m_85849_();
        tx = 0.0f;
        tz = -0.59375f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)tx, -0.21875, (double)tz);
        matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), press * 90.0f, true));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "press");
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, (double)liftPress, 0.0);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "pressLift");
        matrixStack.m_85849_();
        for (int i = 0; i < itemDisplays.length; ++i) {
            MultiblockProcess process;
            if (itemDisplays[i] == null || !((process = (MultiblockProcess)blockEntity.processQueue.get(i)) instanceof MultiblockProcessInWorld)) continue;
            MultiblockProcessInWorld inWorld = (MultiblockProcessInWorld)process;
            float scale = 0.3125f;
            List<ItemStack> dList = inWorld.getDisplayItem();
            if (dList.isEmpty()) continue;
            if (dList.size() < 2) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)itemDisplays[i][1], (double)itemDisplays[i][2], (double)itemDisplays[i][3]);
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), itemDisplays[i][4], true));
                matrixStack.m_85841_(scale, scale, 0.5f);
                ClientUtils.mc().m_91291_().m_174269_(dList.get(0), ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
                continue;
            }
            int size = dList.size();
            int lines = (int)Math.ceil((float)size / 2.0f);
            float spacer = (float)(lines - 1) * 0.234375f;
            for (int d = 0; d < size; ++d) {
                float oX = (size > 2 ? -0.3125f : 0.0f) + (float)(lines - d / 2) * 0.0625f + (float)(d % 2) * 0.3125f;
                float oZ = -spacer / 2.0f + (float)(d / 2) * 0.234375f;
                float oY = 0.0f;
                float localItemX = itemDisplays[i][1] + oX;
                float localItemY = itemDisplays[i][2] + oY;
                float localItemZ = itemDisplays[i][3] + oZ;
                float subProcess = itemDisplays[i][0] - (float)(d / 2 * 4);
                float localAngle = itemDisplays[i][4];
                if (subProcess <= 24.0f) {
                    localAngle = 67.5f;
                    if (subProcess <= 19.0f) {
                        localItemZ = -0.75f + (19.0f - subProcess) / 10.0f * 0.5f;
                        localItemY = -0.09375f + (19.0f - subProcess) / 10.0f * 0.21875f;
                    } else {
                        localItemZ = -1.0f + (oZ - (24.0f - subProcess) / 5.0f * oZ);
                        localItemY = -0.34375f + (24.0f - subProcess) / 5.0f * 0.25f;
                    }
                }
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)localItemX, (double)localItemY, (double)localItemZ);
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), localAngle, true));
                matrixStack.m_85841_(scale, scale, 0.5f);
                ClientUtils.mc().m_91291_().m_174269_(dList.get(d), ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
            }
        }
        double playerDistanceSq = ClientUtils.mc().f_91074_.m_20238_(Vec3.m_82512_((Vec3i)blockPos));
        if (!blueprintStack.m_41619_() && playerDistanceSq < 1000.0) {
            BlueprintLines blueprint;
            BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(blueprintStack, "blueprint"));
            BlueprintCraftingRecipe recipe = blockEntity.selectedRecipe < 0 || blockEntity.selectedRecipe >= recipes.length ? null : recipes[blockEntity.selectedRecipe];
            BlueprintLines blueprintLines = blueprint = recipe == null ? null : AutoWorkbenchRenderer.getBlueprintDrawable(recipe, blockEntity.getLevelNonnull());
            if (blueprint != null) {
                float lineWidth = playerDistanceSq < 6.0 ? 3.0f : (playerDistanceSq < 25.0 ? 2.0f : (playerDistanceSq < 40.0 ? 1.0f : 0.5f));
                matrixStack.m_85836_();
                matrixStack.m_85837_(-0.195, 0.125, 0.97);
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -45.0f, true));
                float scale = 0.5f / (float)blueprint.textureScale;
                matrixStack.m_85841_(scale, -scale, scale);
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                blueprint.draw(lineWidth, matrixStack, bufferIn);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
    }

    public static void renderModelPart(PoseStack matrix, BlockRenderDispatcher blockRenderer, MultiBufferSource buffers, BlockState state, BakedModel model, int light, int overlay, String parts) {
        matrix.m_85836_();
        matrix.m_85837_(-0.5, -0.5, -0.5);
        SinglePropertyModelData<IEProperties.VisibilityList> data = new SinglePropertyModelData<IEProperties.VisibilityList>(IEProperties.VisibilityList.show(parts), DynamicSubmodelCallbacks.getProperty());
        blockRenderer.m_110937_().renderModel(matrix.m_85850_(), buffers.m_6299_(RenderType.m_110451_()), state, model, 1.0f, 1.0f, 1.0f, light, overlay, data);
        matrix.m_85849_();
    }

    public static BlueprintLines getBlueprintDrawable(BlueprintCraftingRecipe recipe, Level world) {
        if (recipe == null) {
            return null;
        }
        BlueprintLines blueprint = blueprintCache.get(recipe);
        if (blueprint == null) {
            blueprint = AutoWorkbenchRenderer.getBlueprintDrawable(recipe.output, world);
            blueprintCache.put(recipe, blueprint);
        }
        return blueprint;
    }

    public static BlueprintLines getBlueprintDrawable(ItemStack stack, Level world) {
        if (stack.m_41619_()) {
            return null;
        }
        LocalPlayer player = ClientUtils.mc().f_91074_;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            BakedModel ibakedmodel = ClientUtils.mc().m_91291_().m_174264_(stack, world, (LivingEntity)player, 0);
            HashSet<String> textures = new HashSet<String>();
            List quads = ibakedmodel.getQuads(null, null, world.f_46441_, (IModelData)EmptyModelData.INSTANCE);
            for (BakedQuad bakedQuad : quads) {
                if (bakedQuad == null) continue;
                bakedQuad.m_173410_();
                textures.add(bakedQuad.m_173410_().m_118413_().toString());
            }
            for (String string : textures) {
                ResourceLocation rl = new ResourceLocation(string);
                rl = new ResourceLocation(rl.m_135827_(), String.format("%s/%s%s", "textures", rl.m_135815_(), ".png"));
                Resource resource = ClientUtils.mc().m_91098_().m_142591_(rl);
                BufferedImage bufferedImage = ClientUtils.readBufferedImage(resource.m_6679_());
                if (bufferedImage == null) continue;
                images.add(bufferedImage);
            }
        }
        catch (Exception ibakedmodel) {
            // empty catch block
        }
        if (images.isEmpty()) {
            return null;
        }
        ArrayList lines = new ArrayList();
        HashSet<TexturePoint> testSet = new HashSet<TexturePoint>();
        HashMultimap area = HashMultimap.create();
        int wMax = 0;
        for (BufferedImage bufferedImage : images) {
            HashSet<Pair> temp_lines = new HashSet<Pair>();
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            if (h > w) {
                h = w;
            }
            if (w > wMax) {
                wMax = w;
            }
            for (int hh = 0; hh < h; ++hh) {
                for (int ww = 0; ww < w; ++ww) {
                    int argb = bufferedImage.getRGB(ww, hh);
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    float intesity = (r + b + g) / 3.0f;
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    boolean added = false;
                    TexturePoint tp = new TexturePoint(ww, hh, w);
                    if (!testSet.contains(tp)) {
                        for (Integer key : area.keySet()) {
                            for (TexturePoint p : area.get((Object)key)) {
                                float dB;
                                float dG;
                                float mod = (float)w / (float)p.scale;
                                int pColour = bufferedImage.getRGB((int)((float)p.x * mod), (int)((float)p.y * mod));
                                float dR = r - (float)(pColour >> 16 & 0xFF) / 255.0f;
                                double delta = Math.sqrt(dR * dR + (dG = g - (float)(pColour >> 8 & 0xFF) / 255.0f) * dG + (dB = b - (float)(pColour & 0xFF) / 255.0f) * dB);
                                if (!(delta < 0.25)) continue;
                                area.put((Object)key, (Object)tp);
                                added = true;
                                break;
                            }
                            if (!added) continue;
                            break;
                        }
                        if (!added) {
                            area.put((Object)argb, (Object)tp);
                        }
                        testSet.add(tp);
                    }
                    for (int i = 0; i < 4; ++i) {
                        int xx;
                        int n = i == 0 ? -1 : (xx = i == 1 ? 1 : 0);
                        int yy = i == 2 ? -1 : (i == 3 ? 1 : 0);
                        int u = ww + xx;
                        int v = hh + yy;
                        int neighbour = 0;
                        float delta = 1.0f;
                        boolean notTransparent = false;
                        if (u >= 0 && u < w && v >= 0 && v < h) {
                            neighbour = bufferedImage.getRGB(u, v);
                            boolean bl = notTransparent = (neighbour >> 24 & 0xFF) > 0;
                            if (notTransparent) {
                                float bDelta;
                                float gDelta;
                                float rDelta;
                                float neighbourIntesity = (float)((neighbour >> 16 & 0xFF) + (neighbour >> 8 & 0xFF) + (neighbour & 0xFF)) / 765.0f;
                                float intesityDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(intesity - neighbourIntesity)));
                                delta = Math.max(intesityDelta, Math.max(rDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(r - (float)(neighbour >> 16 & 0xFF) / 255.0f))), Math.max(gDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(g - (float)(neighbour >> 8 & 0xFF) / 255.0f))), bDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(b - (float)(neighbour & 0xFF) / 255.0f))))));
                                float f = (double)delta < 0.25 ? 0.0f : (delta = (double)delta > 0.4 ? 1.0f : delta);
                            }
                        }
                        if (!(delta > 0.0f)) continue;
                        Pair l = Pair.of((Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 0)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 0)), w), (Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 1)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 1)), w));
                        temp_lines.add(l);
                    }
                }
            }
            lines.addAll(temp_lines);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(area.keySet());
        arrayList.sort(Comparator.comparingDouble(AutoWorkbenchRenderer::getLuminance));
        HashMultimap complete_areaMap = HashMultimap.create();
        int lineNumber = 2;
        int lineStyle = 0;
        for (Integer i : arrayList) {
            Set styleSlot = complete_areaMap.get((Object)new ShadeStyle(lineNumber, lineStyle));
            for (TexturePoint point : area.get((Object)i)) {
                styleSlot.add(new Point(point.x(), point.y()));
            }
            ++lineStyle;
            if ((lineStyle %= 3) != 0) continue;
            ++lineNumber;
        }
        HashSet<Pair<Point, Point>> complete_lines = new HashSet<Pair<Point, Point>>();
        for (Pair line : lines) {
            TexturePoint p1 = (TexturePoint)line.getFirst();
            TexturePoint p2 = (TexturePoint)line.getSecond();
            complete_lines.add((Pair<Point, Point>)Pair.of((Object)new Point((int)((float)p1.x / (float)p1.scale * (float)wMax), (int)((float)p1.y / (float)p1.scale * (float)wMax)), (Object)new Point((int)((float)p2.x / (float)p2.scale * (float)wMax), (int)((float)p2.y / (float)p2.scale * (float)wMax))));
        }
        return new BlueprintLines(wMax, complete_lines, (HashMultimap<ShadeStyle, Point>)complete_areaMap);
    }

    private static void line2d(VertexConsumer out, float x0, float y0, float x1, float y1) {
        float normalX = x1 - x0;
        float normalY = y1 - y0;
        out.m_5483_((double)x0, (double)y0, 0.0).m_5601_(normalX, normalY, 0.0f).m_5752_();
        out.m_5483_((double)x1, (double)y1, 0.0).m_5601_(normalX, normalY, 0.0f).m_5752_();
    }

    private static double getLuminance(int rgb) {
        return Math.sqrt(0.241 * (double)(rgb >> 16 & 0xFF) + 0.691 * (double)(rgb >> 8 & 0xFF) + 0.068 * (double)(rgb & 0xFF));
    }

    static {
        blueprintCache = new HashMap();
    }

    public static class BlueprintLines {
        final int textureScale;
        final Set<Pair<Point, Point>> lines;
        final HashMultimap<ShadeStyle, Point> areas;

        BlueprintLines(int textureScale, Set<Pair<Point, Point>> lines, HashMultimap<ShadeStyle, Point> areas) {
            this.textureScale = textureScale;
            this.lines = lines;
            this.areas = areas;
        }

        public int getTextureScale() {
            return this.textureScale;
        }

        public void draw(float lineWidth, PoseStack matrixStack, MultiBufferSource buffer) {
            RenderType type = IERenderTypes.getLines(lineWidth);
            VertexConsumer baseBuilder = buffer.m_6299_(type);
            TransformingVertexBuilder builder = new TransformingVertexBuilder(baseBuilder, matrixStack, type.m_110508_());
            builder.m_142461_(255, 255, 255, 255);
            for (Pair<Point, Point> line : this.lines) {
                AutoWorkbenchRenderer.line2d(builder, ((Point)line.getFirst()).x, ((Point)line.getFirst()).y, ((Point)line.getSecond()).x, ((Point)line.getSecond()).y);
            }
            if (lineWidth >= 1.0f) {
                for (ShadeStyle style : this.areas.keySet()) {
                    for (Point pixel : this.areas.get((Object)style)) {
                        style.drawShading(pixel, builder);
                    }
                }
            }
            builder.m_141991_();
        }
    }

    private record TexturePoint(int x, int y, int scale) {
    }

    private static class ShadeStyle {
        int stripeAmount = 1;
        int stripeDirection = 0;

        ShadeStyle(int stripeAmount, int stripeDirection) {
            this.stripeAmount = stripeAmount;
            this.stripeDirection = stripeDirection;
        }

        void drawShading(Point pixel, VertexConsumer builder) {
            float step = 1.0f / (float)this.stripeAmount;
            float offset = step / 2.0f;
            if (this.stripeDirection > 1) {
                int perSide = this.stripeAmount / 2 + (this.stripeAmount % 2 == 1 ? 1 : 0);
                step = 1.0f / (float)perSide;
                offset = this.stripeAmount % 2 == 1 ? step : step / 2.0f;
            }
            for (int i = 0; i < this.stripeAmount; ++i) {
                if (this.stripeDirection == 0) {
                    AutoWorkbenchRenderer.line2d(builder, (float)pixel.x + offset + step * (float)i, pixel.y, (float)pixel.x + offset + step * (float)i, pixel.y + 1);
                    continue;
                }
                if (this.stripeDirection == 1) {
                    AutoWorkbenchRenderer.line2d(builder, pixel.x, (float)pixel.y + offset + step * (float)i, pixel.x + 1, (float)pixel.y + offset + step * (float)i);
                    continue;
                }
                if (this.stripeDirection != 2) continue;
                if (i == this.stripeAmount - 1 && this.stripeAmount % 2 == 1) {
                    AutoWorkbenchRenderer.line2d(builder, pixel.x, pixel.y + 1, pixel.x + 1, pixel.y);
                    continue;
                }
                if (i % 2 == 0) {
                    AutoWorkbenchRenderer.line2d(builder, pixel.x, (float)pixel.y + offset + step * (float)(i / 2), (float)pixel.x + offset + step * (float)(i / 2), pixel.y);
                    continue;
                }
                AutoWorkbenchRenderer.line2d(builder, (float)(pixel.x + 1) - offset - step * (float)(i / 2), pixel.y + 1, pixel.x + 1, (float)(pixel.y + 1) - offset - step * (float)(i / 2));
            }
        }
    }
}

