/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.split.BakedBasicSplitModel;
import blusunrize.immersiveengineering.client.models.split.BakedDynamicSplitModel;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class UnbakedSplitModel
implements IModelGeometry<UnbakedSplitModel> {
    private final IModelGeometry<?> baseModel;
    private final Set<Vec3i> parts;
    private final boolean dynamic;
    private final Vec3i size;

    public UnbakedSplitModel(IModelGeometry<?> baseModel, List<Vec3i> parts, boolean dynamic, Vec3i size) {
        this.baseModel = baseModel;
        this.parts = new HashSet<Vec3i>(parts);
        this.dynamic = dynamic;
        this.size = size;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel bakedBase = this.baseModel.bake(owner, bakery, spriteGetter, (ModelState)BlockModelRotation.X0_Y0, overrides, modelLocation);
        if (this.dynamic) {
            return new BakedDynamicSplitModel((ICacheKeyProvider)bakedBase, this.parts, modelTransform, this.size);
        }
        return new BakedBasicSplitModel(bakedBase, this.parts, modelTransform, this.size);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.baseModel.getTextures(owner, modelGetter, missingTextureErrors);
    }
}

