/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallback;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class MaterialSpriteGetter<T>
implements BiFunction<String, Material, TextureAtlasSprite> {
    private final Function<Material, TextureAtlasSprite> getter;
    private final String groupName;
    private final IEOBJCallback<T> callback;
    private final T key;
    private final ShaderCase shaderCase;
    private int renderPass = 0;

    public MaterialSpriteGetter(Function<Material, TextureAtlasSprite> getter, String groupName, IEOBJCallback<T> callback, T key, ShaderCase shaderCase) {
        this.getter = getter;
        this.groupName = groupName;
        this.callback = callback;
        this.key = key;
        this.shaderCase = shaderCase;
    }

    public void setRenderPass(int pass) {
        this.renderPass = pass;
    }

    @Override
    public TextureAtlasSprite apply(String material, Material resourceLocation) {
        ResourceLocation rl;
        TextureAtlasSprite sprite = null;
        if (this.callback != null) {
            sprite = this.callback.getTextureReplacement(this.key, this.groupName, material);
        }
        if (this.shaderCase != null && (rl = this.shaderCase.getTextureReplacement(this.groupName, this.renderPass)) != null) {
            sprite = this.getter.apply(new Material(InventoryMenu.f_39692_, rl));
        }
        if (sprite == null) {
            sprite = this.getter.apply(resourceLocation);
        }
        return sprite;
    }
}

