/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.DynamicBucketModel;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public final class PotionBucketModel
implements IModelGeometry<PotionBucketModel> {
    private final QuadTransformer recolorTransformer;
    private final IModelGeometry<?> baseGeometry = new DynamicBucketModel((Fluid)IEFluids.POTION.get(), false, true, true, true);

    public PotionBucketModel(int color) {
        this.recolorTransformer = new QuadTransformer(new Transformation(null), $ -> color);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel baseModel = this.baseGeometry.bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(owner.getCombinedTransform(), modelTransform));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)baseModel.getParticleIcon((IModelData)EmptyModelData.INSTANCE), (ItemOverrides)new OverrideHandler(overrides, bakery, owner), (ImmutableMap)transformMap);
        ResourceLocation fluidMaskLocation = ((PotionFluid)IEFluids.POTION.get()).getAttributes().getStillTexture();
        for (Pair layer : baseModel.getLayerModels(ItemStack.f_41583_, false)) {
            List baseQuads = ((BakedModel)layer.getFirst()).getQuads(null, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(baseQuads.size());
            for (BakedQuad baseQuad : baseQuads) {
                if (baseQuad.m_173410_().m_118413_().equals((Object)fluidMaskLocation)) {
                    newQuads.add(this.recolorTransformer.apply(baseQuad));
                    continue;
                }
                newQuads.add(baseQuad);
            }
            builder.addQuads((RenderType)layer.getSecond(), newQuads);
        }
        return builder.build();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.baseGeometry.getTextures(owner, modelGetter, missingTextureErrors);
    }

    private static class OverrideHandler
    extends ItemOverrides {
        private final Int2ObjectMap<BakedModel> coloredModels = new Int2ObjectOpenHashMap();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;

        private OverrideHandler(ItemOverrides nested, ModelBakery bakery, IModelConfiguration owner) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
        }

        @Nullable
        public BakedModel m_173464_(@Nonnull BakedModel model, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int unused) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (fluid.isEmpty()) {
                return this.nested.m_173464_(model, stack, world, livingEntity, unused);
            }
            int color = fluid.getFluid().getAttributes().getColor(fluid);
            return (BakedModel)this.coloredModels.computeIfAbsent(color, i -> new PotionBucketModel(i).bake(this.owner, this.bakery, ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, this, ImmersiveEngineering.rl("potion_bucket_override")));
        }
    }

    public static class Loader
    implements IModelLoader<PotionBucketModel> {
        public static final ResourceLocation LOADER_NAME = ImmersiveEngineering.rl("potion_bucket");

        public void m_6213_(@Nonnull ResourceManager resourceManager) {
        }

        @Nonnull
        public PotionBucketModel read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
            return new PotionBucketModel(-1);
        }
    }
}

