/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.client.models.ModelIEArmorBase;
import blusunrize.immersiveengineering.client.render.entity.IEModelLayers;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.base.Function;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ModelPowerpack {
    private static final Supplier<ArmorModel> MODEL = Suppliers.memoize(() -> {
        EntityModelSet models = Minecraft.m_91087_().m_167973_();
        ModelPart layer = models.m_171103_(IEModelLayers.POWERPACK);
        return new ArmorModel(layer);
    });
    private static final ResourceLocation POWERPACK_TEXTURE = ImmersiveEngineering.rl("textures/models/powerpack.png");
    public static final LoadingCache<CatenaryKey, Vec3[]> catenaryCacheLeft = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(ModelPowerpack.makeCacheCreator(false)));
    public static final LoadingCache<CatenaryKey, Vec3[]> catenaryCacheRight = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(ModelPowerpack.makeCacheCreator(true)));

    public static void render(LivingEntity toRender, ItemStack powerpack, PoseStack matrixStackIn, MultiBufferSource buffers, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ArmorModel model = MODEL.get();
        model.m_6973_(toRender, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (powerpack != null) {
            float max = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)powerpack);
            float storage = Math.max(0.0f, (float)EnergyHelper.getEnergyStored((ICapabilityProvider)powerpack) / max);
            model.meterNeedle.f_104205_ = 0.5235987f - 1.047197f * storage;
        }
        RenderType type = model.m_103119_(POWERPACK_TEXTURE);
        model.m_7695_(matrixStackIn, buffers.m_6299_(type), packedLightIn, packedOverlayIn, red, green, blue, alpha);
        TextureAtlasSprite wireTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ImmersiveEngineering.rl("block/wire"));
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = toRender.m_21120_(hand);
            if (stack.m_41619_() || !EnergyHelper.isFluxRelated((ICapabilityProvider)stack)) continue;
            boolean right = hand == InteractionHand.MAIN_HAND == (toRender.m_5737_() == HumanoidArm.RIGHT);
            float angleX = (right ? model.f_102811_ : model.f_102812_).f_104203_;
            float angleZ = (right ? model.f_102811_ : model.f_102812_).f_104205_;
            Vec3[] vex = (Vec3[])(right ? catenaryCacheRight : catenaryCacheLeft).getUnchecked((Object)new CatenaryKey((int)(angleX * 1024.0f), (int)(angleZ * 1024.0f)));
            float vStep = 1.0f / (float)vex.length;
            TransformingVertexBuilder builder = new TransformingVertexBuilder(buffers, RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_), matrixStackIn);
            double scaleX = right ? -1.0 : 1.0;
            builder.defaultColor(0.93f, 0.63f, 0.27f, 1.0f);
            builder.setLight(packedLightIn);
            builder.setOverlay(packedOverlayIn);
            float v0 = wireTexture.m_118411_();
            float v1 = wireTexture.m_118412_();
            for (int i = 1; i < vex.length; ++i) {
                for (int offset = 0; offset < 2; ++offset) {
                    double tmp;
                    Vec3 vec;
                    int iHere = i - offset;
                    int iThere = i - 1 + offset;
                    Vec3 vecHere = vex[iHere];
                    Vec3 vecThere = vex[iThere];
                    builder.setNormal((float)(vecThere.f_82481_ - vecHere.f_82481_), 0.0f, (float)(vecHere.f_82479_ - vecThere.f_82479_));
                    for (int index : new int[]{iHere, iThere}) {
                        vec = vex[index];
                        double xA = scaleX * vec.f_82479_ - 0.015625;
                        double xB = scaleX * vec.f_82479_ + 0.015625;
                        if (index == iHere) {
                            tmp = xA;
                            xA = xB;
                            xB = tmp;
                        }
                        builder.m_5483_(xA, -vec.f_82480_, vec.f_82481_).m_7421_(wireTexture.m_118367_((double)(vStep * (float)index)), v0).m_5752_();
                        builder.m_5483_(xB, -vec.f_82480_, vec.f_82481_).m_7421_(wireTexture.m_118367_((double)(vStep * (float)index)), v1).m_5752_();
                    }
                    builder.setNormal((float)(vecThere.f_82480_ - vecHere.f_82480_), (float)(vecHere.f_82479_ - vecThere.f_82479_), 0.0f);
                    for (int index : new int[]{iHere, iThere}) {
                        vec = vex[index];
                        double yA = -vec.f_82480_ - 0.015625;
                        double yB = -vec.f_82480_;
                        if (index == iThere) {
                            tmp = yA;
                            yA = yB;
                            yB = tmp;
                        }
                        builder.m_5483_(scaleX * vec.f_82479_, yA, vec.f_82481_).m_7421_(wireTexture.m_118367_((double)(vStep * (float)index)), v0).m_5752_();
                        builder.m_5483_(scaleX * vec.f_82479_, yB, vec.f_82481_).m_7421_(wireTexture.m_118367_((double)(vStep * (float)index)), v1).m_5752_();
                    }
                }
            }
        }
    }

    private static Function<CatenaryKey, Vec3[]> makeCacheCreator(boolean right) {
        return key -> {
            double angleX = (double)key.xTimes1024 / 1024.0;
            double angleZ = (double)key.zTimes1024 / 1024.0;
            double armLength = 0.75;
            double x = 0.3125 + (double)(right ? 1 : -1) * armLength * Math.sin(angleZ);
            double y = armLength * Math.cos(angleX);
            double z = armLength * Math.sin(angleX);
            return WireUtils.getConnectionCatenary(new Vec3(0.484375, -0.75, 0.25), new Vec3(x, -y, z), 1.5);
        };
    }

    public static LayerDefinition createLayers() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_("part0", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-4.0f, -5.0f, -2.0f, 8.0f, 10.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)4.0f));
        PartDefinition part1 = body.m_171599_("part1", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-3.0f, -2.0f, -2.0f, 6.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)4.0f));
        body.m_171599_("part2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)-5.0f, (float)5.0f, (float)3.0f));
        body.m_171599_("part3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171423_((float)5.0f, (float)5.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        body.m_171599_("gauge1", CubeListBuilder.m_171558_().m_171514_(40, 13).m_171481_(-0.5f, -1.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)-3.0f, (float)5.5f, (float)5.0f));
        body.m_171599_("gauge2", CubeListBuilder.m_171558_().m_171514_(40, 13).m_171481_(-0.5f, -1.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)1.0f, (float)5.5f, (float)5.0f));
        body.m_171599_("gauge3", CubeListBuilder.m_171558_().m_171514_(44, 13).m_171481_(-2.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-0.5f, (float)3.5f, (float)5.0f));
        body.m_171599_("gauge4", CubeListBuilder.m_171558_().m_171514_(44, 13).m_171481_(-2.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-0.5f, (float)7.5f, (float)5.0f));
        body.m_171599_("meterNeedle", CubeListBuilder.m_171558_().m_171514_(52, 14).m_171488_(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)-1.0f, (float)7.625f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition connector = part1.m_171599_("connector", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        connector.m_171599_("part1", CubeListBuilder.m_171558_().m_171514_(17, 9).m_171481_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-4.5f, (float)0.0f, (float)0.0f));
        connector.m_171599_("part2", CubeListBuilder.m_171558_().m_171514_(17, 9).m_171488_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.375f)), PartPose.m_171419_((float)-6.0f, (float)0.0f, (float)0.0f));
        connector.m_171599_("part3", CubeListBuilder.m_171558_().m_171514_(29, 9).m_171481_(-1.0f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-6.25f, (float)0.0f, (float)0.0f));
        connector.m_171599_("part4", CubeListBuilder.m_171558_().m_171514_(12, 8).m_171481_(-0.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-7.5f, (float)0.0f, (float)0.0f));
        connector.m_171599_("part5", CubeListBuilder.m_171558_().m_171514_(17, 9).m_171481_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        connector.m_171599_("part6", CubeListBuilder.m_171558_().m_171514_(17, 9).m_171488_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.375f)), PartPose.m_171423_((float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        connector.m_171599_("part7", CubeListBuilder.m_171558_().m_171514_(29, 9).m_171481_(-1.0f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f), PartPose.m_171423_((float)6.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        connector.m_171599_("part8", CubeListBuilder.m_171558_().m_171514_(12, 8).m_171481_(-0.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)7.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        for (int i = 0; i < 3; ++i) {
            float pos = 3.125f - (float)i * 2.25f;
            PartDefinition tube = body.m_171599_("tube" + i, CubeListBuilder.m_171558_().m_171514_(56, 19).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)pos, (float)1.0f, (float)5.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
            tube.m_171599_("part1", CubeListBuilder.m_171558_().m_171514_(52, 18).m_171481_(-0.5f, -2.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
            tube.m_171599_("part2", CubeListBuilder.m_171558_().m_171514_(56, 15).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-0.75f, (float)0.0f));
            tube.m_171599_("part3", CubeListBuilder.m_171558_().m_171514_(56, 13).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-2.25f, (float)0.0f));
            tube.m_171599_("part4", CubeListBuilder.m_171558_().m_171514_(56, 13).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)64, (int)32);
    }

    private static class ArmorModel
    extends ModelIEArmorBase {
        private final ModelPart meterNeedle;

        public ArmorModel(ModelPart part) {
            super(part, RenderType::m_110473_);
            this.meterNeedle = part.m_171324_("body").m_171324_("meterNeedle");
        }
    }

    private record CatenaryKey(int xTimes1024, int zTimes1024) {
    }
}

