/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonDyeColor;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherBlockEntity;
import blusunrize.immersiveengineering.common.gui.ItemBatcherContainer;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;

public class ItemBatcherScreen
extends IEContainerScreen<ItemBatcherContainer> {
    private static final ResourceLocation TEXTURE = ItemBatcherScreen.makeTextureLocation("item_batcher");
    private final ItemBatcherBlockEntity tile;
    private GuiButtonState<ItemBatcherBlockEntity.BatchMode> buttonBatchMode;
    private final GuiButtonDyeColor[] buttonsRedstone = new GuiButtonDyeColor[9];

    public ItemBatcherScreen(ItemBatcherContainer container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.tile = (ItemBatcherBlockEntity)container.tile;
        this.f_97727_ = 199;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        ClientUtils.mc().f_91068_.m_90926_(true);
        this.m_169413_();
        this.buttonBatchMode = new GuiButtonState<ItemBatcherBlockEntity.BatchMode>(this.f_97735_ + 7, this.f_97736_ + 92, 18, 18, TextComponent.f_131282_, ItemBatcherBlockEntity.BatchMode.values(), this.tile.batchMode.ordinal(), TEXTURE, 176, 36, 1, btn -> {
            CompoundTag tag = new CompoundTag();
            this.tile.batchMode = (ItemBatcherBlockEntity.BatchMode)((Object)((Object)btn.getNextState()));
            tag.m_128344_("batchMode", (byte)this.tile.batchMode.ordinal());
            this.handleButtonClick(tag);
        }, ItemBatcherScreen::gatherBatchmodeTooltip);
        this.m_142416_((GuiEventListener)this.buttonBatchMode);
        for (int slot = 0; slot < 9; ++slot) {
            int finalSlot = slot;
            this.buttonsRedstone[slot] = new GuiButtonDyeColor(this.f_97735_ + 12 + slot * 18, this.f_97736_ + 77, "", (DyeColor)this.tile.redstoneColors.get(slot), btn -> {
                CompoundTag tag = new CompoundTag();
                this.tile.redstoneColors.set(finalSlot, (Object)((DyeColor)btn.getNextState()));
                tag.m_128405_("redstoneColor_slot", finalSlot);
                tag.m_128405_("redstoneColor_val", ((DyeColor)this.tile.redstoneColors.get(finalSlot)).m_41060_());
                this.handleButtonClick(tag);
            }, ItemBatcherScreen::gatherRedstoneTooltip);
            this.m_142416_((GuiEventListener)this.buttonsRedstone[slot]);
        }
    }

    protected void handleButtonClick(CompoundTag nbt) {
        if (!nbt.m_128456_()) {
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageBlockEntitySync(this.tile, nbt));
            this.m_7856_();
        }
    }

    protected void m_7027_(PoseStack transform, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(transform, I18n.m_118938_((String)"block.immersiveengineering.item_batcher", (Object[])new Object[0]), 8.0f, 6.0f, 1641222);
        this.f_96547_.m_92883_(transform, I18n.m_118938_((String)"gui.immersiveengineering.config.item_batcher.filter", (Object[])new Object[0]), 8.0f, 20.0f, 0xE0E0E0);
        this.f_96547_.m_92883_(transform, I18n.m_118938_((String)"gui.immersiveengineering.config.item_batcher.buffer", (Object[])new Object[0]), 8.0f, 49.0f, 0xE0E0E0);
    }

    private static void gatherBatchmodeTooltip(List<Component> out, ItemBatcherBlockEntity.BatchMode mode) {
        out.add((Component)new TranslatableComponent("gui.immersiveengineering.config.item_batcher.batchmode"));
        out.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent("gui.immersiveengineering.config.item_batcher.batchmode." + mode.name()), ChatFormatting.GRAY));
    }

    private static void gatherRedstoneTooltip(List<Component> out, DyeColor color) {
        out.add((Component)new TranslatableComponent("gui.immersiveengineering.config.item_batcher.redstone_color"));
        out.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent("color.minecraft." + color.m_41065_()), ChatFormatting.GRAY));
    }
}

