/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.impl;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public abstract class ImmersiveConnectableBlockEntity
extends BlockEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void m_142339_(Level world) {
        super.m_142339_(world);
        this.globalNet = GlobalWireNetwork.getNetwork(world);
    }

    @Nonnull
    public IModelData getModelData() {
        IEProperties.ConnectionModelData state = ConnectorBlockEntityHelper.genConnBlockState(this.f_58857_, this);
        return CombinedModelData.combine(new SinglePropertyModelData<IEProperties.ConnectionModelData>(state, IEProperties.Model.CONNECTIONS), super.getModelData());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload(this.globalNet, this);
        this.isUnloaded = true;
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad(this, this.f_58857_);
        this.isUnloaded = false;
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            ConnectorBlockEntityHelper.remove(this.f_58857_, this);
        }
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        return ConnectorBlockEntityHelper.getLocalNetWithCache(this.globalNet, this.m_58899_(), cpIndex, this.cachedLocalNets);
    }
}

