/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class ConnectorBlockEntityHelper {
    public static IEProperties.ConnectionModelData genConnBlockState(Level world, IImmersiveConnectable iic) {
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        BlockPos pos = iic.getPosition();
        HashSet<Connection> ret = new HashSet<Connection>();
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            LocalWireNetwork local = globalNet.getLocalNet(cp);
            Collection<Connection> conns = local.getConnections(cp);
            if (conns == null) {
                WireLogger.logger.warn("Aborting and returning empty data: null connections at {}", (Object)cp);
                return new IEProperties.ConnectionModelData((Set<Connection>)ImmutableSet.of(), pos);
            }
            for (Connection c : conns) {
                IImmersiveConnectable otherConnector;
                ConnectionPoint other = c.getOtherEnd(cp);
                if (c.isInternal() || (otherConnector = globalNet.getLocalNet(other).getConnector(other)) == null || otherConnector.isProxy()) continue;
                ret.add(c);
            }
        }
        return new IEProperties.ConnectionModelData(ret, pos);
    }

    public static void onChunkUnload(GlobalWireNetwork globalNet, IImmersiveConnectable iic) {
        globalNet.onConnectorUnload(iic);
    }

    public static void onChunkLoad(IImmersiveConnectable iic, Level world) {
        GlobalWireNetwork.getNetwork(world).onConnectorLoad(iic, world);
    }

    public static void remove(Level world, IImmersiveConnectable iic) {
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        if (!world.f_46443_) {
            BlockPos pos = iic.getPosition();
            Consumer<Connection> dropHandler = world.m_46469_().m_46207_(GameRules.f_46136_) ? c -> {
                if (!c.isInternal()) {
                    BlockPos end = c.getOtherEnd(c.getEndFor(pos)).getPosition();
                    double dx = (double)pos.m_123341_() + 0.5 + (double)Math.signum(end.m_123341_() - pos.m_123341_());
                    double dy = (double)pos.m_123342_() + 0.5 + (double)Math.signum(end.m_123342_() - pos.m_123342_());
                    double dz = (double)pos.m_123343_() + 0.5 + (double)Math.signum(end.m_123343_() - pos.m_123343_());
                    world.m_7967_((Entity)new ItemEntity(world, dx, dy, dz, c.type.getWireCoil((Connection)c)));
                }
            } : c -> {};
            for (ConnectionPoint cp : iic.getConnectionPoints()) {
                globalNet.removeAllConnectionsAt(cp, dropHandler);
            }
        }
        if (world.f_46443_ && WireUtils.hasAnyConnections(globalNet, iic)) {
            globalNet.onConnectorUnload(iic);
        } else {
            globalNet.removeConnector(iic);
        }
    }

    public static LocalWireNetwork getLocalNetWithCache(GlobalWireNetwork globalNet, BlockPos pos, int cpIndex, Int2ObjectMap<LocalWireNetwork> cachedLocalNets) {
        LocalWireNetwork ret = (LocalWireNetwork)cachedLocalNets.get(cpIndex);
        ConnectionPoint cp = new ConnectionPoint(pos, cpIndex);
        if (ret == null || !ret.isValid(cp)) {
            ret = globalNet.getLocalNet(cp);
            cachedLocalNets.put(cpIndex, (Object)ret);
        }
        return ret;
    }
}

