/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;

public final class ConnectionPoint
implements Comparable<ConnectionPoint> {
    @Nonnull
    private final BlockPos pos;
    private final int index;

    public ConnectionPoint(@Nonnull BlockPos pos, int index) {
        this.pos = pos;
        this.index = index;
    }

    public ConnectionPoint(CompoundTag nbt) {
        this.pos = NbtUtils.m_129239_((CompoundTag)nbt);
        this.index = nbt.m_128451_("index");
    }

    public CompoundTag createTag() {
        CompoundTag ret = NbtUtils.m_129224_((BlockPos)this.pos);
        ret.m_128405_("index", this.index);
        return ret;
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.pos;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoint that = (ConnectionPoint)o;
        if (this.index != that.index) {
            return false;
        }
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public int compareTo(ConnectionPoint o) {
        int blockCmp = this.pos.compareTo((Vec3i)o.pos);
        if (blockCmp != 0) {
            return blockCmp;
        }
        return Integer.compare(this.index, o.index);
    }

    public String toString() {
        return "[x=" + this.pos.m_123341_() + ", y=" + this.pos.m_123342_() + ", z=" + this.pos.m_123343_() + ", index=" + this.index + "]";
    }

    public int getX() {
        return this.pos.m_123341_();
    }

    public int getY() {
        return this.pos.m_123342_();
    }

    public int getZ() {
        return this.pos.m_123343_();
    }
}

