/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import com.google.common.base.Preconditions;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class Connection {
    @Nonnull
    public final WireType type;
    @Nonnull
    private final ConnectionPoint endA;
    @Nonnull
    private final ConnectionPoint endB;
    private final boolean internal;
    private double length;
    private Vec3 endAOffset;
    private Vec3 endBOffset;
    @Nullable
    private CatenaryData catData;
    boolean blockDataGenerated = false;
    @Nullable
    private LocalWireNetwork cachedLocalNet;
    private int cachedNetVersion = -1;

    private Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB, Vec3 endAOffset, Vec3 endBOffset, boolean internal) {
        this.type = type;
        if (endA.compareTo(endB) < 0) {
            this.endA = endB;
            this.endB = endA;
            this.resetCatenaryData(endBOffset, endAOffset);
        } else {
            this.endA = endA;
            this.endB = endB;
            this.resetCatenaryData(endAOffset, endBOffset);
        }
        this.internal = internal;
    }

    public Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB, Vec3 endAOffset, Vec3 endBOffset) {
        this(type, endA, endB, endAOffset, endBOffset, false);
    }

    public Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB, GlobalWireNetwork netForOffsets) {
        this(type, endA, endB, WireUtils.getConnectionOffset(netForOffsets, endA, endB, type), WireUtils.getConnectionOffset(netForOffsets, endB, endA, type), false);
    }

    public Connection(BlockPos pos, int idA, int idB) {
        this(WireType.INTERNAL_CONNECTION, new ConnectionPoint(pos, idA), new ConnectionPoint(pos, idB), Vec3.f_82478_, Vec3.f_82478_, true);
    }

    public Connection(CompoundTag nbt) {
        this(WireType.getValue(nbt.m_128461_("type")), new ConnectionPoint(nbt.m_128469_("endA")), new ConnectionPoint(nbt.m_128469_("endB")), WireUtils.loadVec3(nbt.m_128423_("endAOffset")), WireUtils.loadVec3(nbt.m_128423_("endBOffset")), nbt.m_128471_("internal"));
    }

    public ConnectionPoint getOtherEnd(ConnectionPoint known) {
        if (known.equals(this.endA)) {
            return this.endB;
        }
        return this.endA;
    }

    @Nonnull
    public ConnectionPoint getEndA() {
        return this.endA;
    }

    @Nonnull
    public ConnectionPoint getEndB() {
        return this.endB;
    }

    public LocalWireNetwork getContainingNet(GlobalWireNetwork global) {
        if (this.cachedLocalNet == null || this.cachedLocalNet.getVersion() != this.cachedNetVersion && !this.cachedLocalNet.isValid(this.getEndA())) {
            this.cachedLocalNet = global.getLocalNet(this.getEndA());
        }
        if (this.cachedLocalNet != null) {
            this.cachedNetVersion = this.cachedLocalNet.getVersion();
        }
        return this.cachedLocalNet;
    }

    public boolean isPositiveEnd(ConnectionPoint p) {
        return p.equals(this.endA);
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("endA", (Tag)this.endA.createTag());
        nbt.m_128365_("endB", (Tag)this.endB.createTag());
        nbt.m_128359_("type", this.type.getUniqueName());
        nbt.m_128379_("internal", this.internal);
        nbt.m_128365_("endAOffset", WireUtils.storeVec3(this.endAOffset));
        nbt.m_128365_("endBOffset", WireUtils.storeVec3(this.endBOffset));
        return nbt;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void generateCatenaryData() {
        Vec3 vecA = this.endAOffset;
        Vec3 vecB = Vec3.m_82528_((Vec3i)this.endB.getPosition().m_141950_((Vec3i)this.endA.getPosition())).m_82549_(this.endBOffset);
        Vec3 delta = vecB.m_82546_(vecA);
        double horLength = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        if (Math.abs(delta.f_82479_) < 0.05 && Math.abs(delta.f_82481_) < 0.05) {
            this.catData = new CatenaryData(true, 0.0, 0.0, 1.0, delta, 0.0, vecA);
            return;
        }
        double wireLength = delta.m_82553_() * this.type.getSlack();
        double goal = Math.sqrt(wireLength * wireLength - delta.f_82480_ * delta.f_82480_) / horLength;
        double lower = 0.0;
        double upper = 1.0;
        while (Math.sinh(upper) / upper < goal) {
            lower = upper;
            upper *= 2.0;
        }
        int iterations = 20;
        for (int i = 0; i < 20; ++i) {
            double middleL = (lower + upper) / 2.0;
            double middleVal = Math.sinh(middleL) / middleL;
            if (middleVal < goal) {
                lower = middleL;
                continue;
            }
            if (middleVal > goal) {
                upper = middleL;
                continue;
            }
            upper = lower = middleL;
            break;
        }
        double l = (lower + upper) / 2.0;
        double scale = horLength / (2.0 * l);
        double offsetX = (0.0 + horLength - scale * Math.log((wireLength + delta.f_82480_) / (wireLength - delta.f_82480_))) * 0.5;
        double offsetY = (delta.f_82480_ + 0.0 - wireLength * Math.cosh(l) / Math.sinh(l)) * 0.5;
        this.catData = new CatenaryData(false, offsetX, offsetY, scale, delta, horLength, vecA);
    }

    public boolean hasCatenaryData() {
        return this.catData != null;
    }

    public boolean isEnd(ConnectionPoint p) {
        return p.equals(this.endA) || p.equals(this.endB);
    }

    public Vec3 getPoint(double pos, ConnectionPoint from) {
        pos = this.transformPosition(pos, from);
        Vec3 basic = this.hasCatenaryData() ? this.getCatenaryData().getPoint(pos) : Vec3.m_82528_((Vec3i)this.endB.getPosition().m_141950_((Vec3i)this.endA.getPosition())).m_82490_(pos);
        Vec3 add = Vec3.f_82478_;
        if (this.endB.equals(from)) {
            add = Vec3.m_82528_((Vec3i)this.endA.getPosition().m_141950_((Vec3i)this.endB.getPosition()));
        }
        return basic.m_82549_(add);
    }

    public double getSlope(double pos, ConnectionPoint from) {
        if (this.hasCatenaryData()) {
            pos = this.transformPosition(pos, from);
            double slope = this.getCatenaryData().getSlope(pos);
            if (this.endB.equals(from)) {
                slope *= -1.0;
            }
            return slope;
        }
        return 0.0;
    }

    public double transformPosition(double pos, ConnectionPoint from) {
        if (this.endB.equals(from)) {
            return 1.0 - pos;
        }
        return pos;
    }

    public ConnectionPoint getEndFor(BlockPos pos) {
        return this.endA.getPosition().equals((Object)pos) ? this.endA : this.endB;
    }

    @Nonnull
    public CatenaryData getCatenaryData() {
        return (CatenaryData)Preconditions.checkNotNull((Object)this.catData);
    }

    void resetCatenaryData(Vec3 newOffsetA, Vec3 newOffsetB) {
        this.catData = null;
        this.endAOffset = newOffsetA;
        this.endBOffset = newOffsetB;
        this.length = Math.sqrt(this.endA.getPosition().m_175582_((Vec3i)this.endB.getPosition(), false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        if (this.internal != that.internal) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.endA.equals(that.endA)) {
            return false;
        }
        return this.endB.equals(that.endB);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.endA.hashCode();
        result = 31 * result + this.endB.hashCode();
        result = 31 * result + (this.internal ? 1 : 0);
        return result;
    }

    public String toString() {
        StringJoiner ret = new StringJoiner(", ", Connection.class.getSimpleName() + "[", "]").add("type=" + this.type).add("endA=" + this.endA).add("endB=" + this.endB);
        if (this.internal) {
            ret.add("internal");
        }
        return ret.toString();
    }

    public ConnectionPoint[] getEnds() {
        return new ConnectionPoint[]{this.endA, this.endB};
    }

    public double getLength() {
        return this.length;
    }

    public Vec3 getEndAOffset() {
        return this.endAOffset;
    }

    public Vec3 getEndBOffset() {
        return this.endBOffset;
    }

    public record CatenaryData(boolean isVertical, double offsetX, double offsetY, double scale, Vec3 delta, double horLength, Vec3 vecA) {
        public CatenaryData reverse(Vec3 otherEndAVec) {
            Vec3 delta = this.delta().m_82490_(-1.0);
            double offsetX = this.horLength - this.offsetX();
            double offsetY = -this.scale * Math.cosh(-offsetX / this.scale);
            return new CatenaryData(this.isVertical, offsetX, offsetY, this.scale, delta, this.horLength, otherEndAVec);
        }

        public double getSlope(double pos) {
            pos = Mth.m_14008_((double)pos, (double)0.0, (double)1.0);
            if (this.isVertical) {
                return Double.POSITIVE_INFINITY * Math.signum(this.getDeltaY());
            }
            return Math.sinh((pos * this.horLength - this.offsetX) / this.scale);
        }

        public Vec3 getPoint(double pos) {
            if (pos == 1.0) {
                return this.vecA.m_82549_(this.delta);
            }
            double x = this.delta.f_82479_ * pos;
            double y = this.isVertical ? this.delta.f_82480_ * pos : this.scale * Math.cosh((this.horLength * pos - this.offsetX) / this.scale) + this.offsetY;
            double z = this.delta.f_82481_ * pos;
            return this.vecA.m_82520_(x, y, z);
        }

        public double getDeltaX() {
            return this.delta.f_82479_;
        }

        public double getDeltaY() {
            return this.delta.f_82480_;
        }

        public double getDeltaZ() {
            return this.delta.f_82481_;
        }
    }

    public record RenderData(CatenaryData data, WireType type, int pointsToRenderSolid, int color) {
        public static final int POINTS_PER_WIRE = 16;

        public static RenderData make(Connection conn, boolean startAtB, int count) {
            Preconditions.checkArgument((boolean)conn.hasCatenaryData());
            CatenaryData basicCatData = conn.getCatenaryData();
            CatenaryData directionalData = startAtB ? basicCatData.reverse(conn.getPoint(0.0, conn.getEndB())) : basicCatData;
            return new RenderData(directionalData, conn.type, count, conn.type.getColour(conn));
        }

        public Vec3 getPoint(int index) {
            return this.data.getPoint((double)index / 16.0);
        }
    }
}

