/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CapabilityReference<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Capability<T> cap;

    public static <T> CapabilityReference<T> forBlockEntityAt(BlockEntity local, Supplier<DirectionalBlockPos> pos, Capability<T> cap) {
        return new BECapReference<T>(() -> ((BlockEntity)local).m_58904_(), pos, cap);
    }

    public static <T> CapabilityReference<T> forRelative(BlockEntity local, Capability<T> cap, Vec3i offset, Direction side) {
        return CapabilityReference.forBlockEntityAt(local, () -> new DirectionalBlockPos(local.m_58899_().m_141952_(offset), side.m_122424_()), cap);
    }

    public static <T> CapabilityReference<T> forNeighbor(BlockEntity local, Capability<T> cap, NonNullSupplier<Direction> side) {
        return CapabilityReference.forBlockEntityAt(local, () -> {
            Direction d = (Direction)side.get();
            return new DirectionalBlockPos(local.m_58899_().m_142300_(d), d.m_122424_());
        }, cap);
    }

    public static <T> CapabilityReference<T> forNeighbor(BlockEntity local, Capability<T> cap, @Nonnull Direction side) {
        return CapabilityReference.forRelative(local, cap, (Vec3i)BlockPos.f_121853_.m_142300_(side), side);
    }

    public static <T> Map<Direction, CapabilityReference<T>> forAllNeighbors(BlockEntity local, Capability<T> cap) {
        EnumMap<Direction, CapabilityReference<T>> neighbors = new EnumMap<Direction, CapabilityReference<T>>(Direction.class);
        for (Direction side : DirectionUtils.VALUES) {
            neighbors.put(side, CapabilityReference.forNeighbor(local, cap, side));
        }
        return neighbors;
    }

    protected CapabilityReference(Capability<T> cap) {
        this.cap = Objects.requireNonNull(cap);
    }

    @Nullable
    public abstract T getNullable();

    @Nonnull
    public T get() {
        return Objects.requireNonNull(this.getNullable());
    }

    public abstract boolean isPresent();

    private static class BECapReference<T>
    extends CapabilityReference<T> {
        private final Supplier<Level> getLevel;
        private final Supplier<DirectionalBlockPos> getPos;
        @Nonnull
        private LazyOptional<T> currentCap = LazyOptional.empty();
        private DirectionalBlockPos lastPos;
        private Level lastWorld;
        private BlockEntity lastBE;

        public BECapReference(Supplier<Level> getLevel, Supplier<DirectionalBlockPos> getPos, Capability<T> cap) {
            super(cap);
            this.getLevel = getLevel;
            this.getPos = getPos;
        }

        @Override
        @Nullable
        public T getNullable() {
            this.updateLazyOptional();
            return (T)this.currentCap.orElse(null);
        }

        @Override
        public boolean isPresent() {
            this.updateLazyOptional();
            return this.currentCap.isPresent();
        }

        private void updateLazyOptional() {
            Level currWorld = this.getLevel.get();
            DirectionalBlockPos currPos = this.getPos.get();
            if (currWorld == null || currPos == null) {
                this.currentCap = LazyOptional.empty();
                this.lastWorld = null;
                this.lastPos = null;
                this.lastBE = null;
            } else if (currWorld != this.lastWorld || !currPos.equals(this.lastPos) || !this.currentCap.isPresent() || this.lastBE != null && this.lastBE.m_58901_()) {
                if (this.currentCap.isPresent() && this.lastBE != null && this.lastBE.m_58901_()) {
                    LOGGER.warn("The tile entity {} (class {}) was removed, but the value {} provided by it for the capability {} is still marked as valid. This is likely a bug in the mod(s) adding the tile entity/the capability", (Object)this.lastBE, this.lastBE.getClass(), this.currentCap.orElseThrow(RuntimeException::new), (Object)this.cap.getName());
                }
                this.lastBE = SafeChunkUtils.getSafeBE((LevelAccessor)currWorld, currPos.position());
                this.currentCap = this.lastBE != null ? this.lastBE.getCapability(this.cap, currPos.side()) : LazyOptional.empty();
                this.lastWorld = currWorld;
                this.lastPos = currPos;
            }
        }
    }
}

