/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.assembler;

import blusunrize.immersiveengineering.api.tool.assembler.FluidStackRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.IngredientRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.ItemStackRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class AssemblerHandler {
    private static final HashMap<Class<? extends Recipe>, IRecipeAdapter> registry = new LinkedHashMap<Class<? extends Recipe>, IRecipeAdapter>();
    private static final List<Function<Object, RecipeQuery>> specialQueryConverters = new ArrayList<Function<Object, RecipeQuery>>();
    private static final List<Function<Ingredient, RecipeQuery>> specialIngredientConverters = new ArrayList<Function<Ingredient, RecipeQuery>>();
    private static final List<Function<ItemStack, RecipeQuery>> specialItemStackConverters = new ArrayList<Function<ItemStack, RecipeQuery>>();
    public static IRecipeAdapter<Recipe<CraftingContainer>> defaultAdapter;

    public static void registerRecipeAdapter(Class<? extends Recipe> recipeClass, IRecipeAdapter adapter) {
        registry.put(recipeClass, adapter);
    }

    @Nonnull
    public static IRecipeAdapter<?> findAdapterForClass(Class<? extends Recipe> recipeClass) {
        IRecipeAdapter<Object> adapter = registry.get(recipeClass);
        boolean isSuperIRecipe = Recipe.class.isAssignableFrom(recipeClass.getSuperclass());
        adapter = adapter == null && recipeClass != Recipe.class && isSuperIRecipe ? AssemblerHandler.findAdapterForClass(recipeClass.getSuperclass()) : defaultAdapter;
        registry.put(recipeClass, adapter);
        return adapter;
    }

    @Nonnull
    public static IRecipeAdapter<?> findAdapter(Recipe recipe) {
        return AssemblerHandler.findAdapterForClass(recipe.getClass());
    }

    public static void registerSpecialIngredientConverter(Function<Ingredient, RecipeQuery> func) {
        specialIngredientConverters.add(func);
    }

    public static void registerSpecialItemStackConverter(Function<ItemStack, RecipeQuery> func) {
        specialItemStackConverters.add(func);
    }

    private static <T> RecipeQuery fromFunctions(T in, List<Function<T, RecipeQuery>> converters) {
        for (Function<T, RecipeQuery> func : converters) {
            RecipeQuery q = func.apply(in);
            if (q == null) continue;
            return q;
        }
        return null;
    }

    @Nullable
    public static RecipeQuery createQueryFromIngredient(Ingredient ingr) {
        RecipeQuery special = AssemblerHandler.fromFunctions(ingr, specialIngredientConverters);
        if (special == null) {
            special = AssemblerHandler.fromFunctions(ingr, specialQueryConverters);
        }
        if (special != null) {
            return special;
        }
        if (ingr.m_43947_()) {
            return null;
        }
        return new IngredientRecipeQuery(ingr, 1);
    }

    @Nullable
    public static RecipeQuery createQueryFromItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        RecipeQuery special = AssemblerHandler.fromFunctions(stack, specialItemStackConverters);
        if (special == null) {
            special = AssemblerHandler.fromFunctions(stack, specialQueryConverters);
        }
        if (special != null) {
            return special;
        }
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            return new FluidStackRecipeQuery(fluidStack);
        }
        return new ItemStackRecipeQuery(stack);
    }

    public static interface IRecipeAdapter<R extends Recipe<CraftingContainer>> {
        @Nullable
        public RecipeQuery[] getQueriedInputs(R var1, NonNullList<ItemStack> var2, Level var3);
    }
}

