/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.utils.FastEither;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class ThermoelectricSource
extends IESerializableRecipe {
    public static RecipeType<ThermoelectricSource> TYPE;
    public static RegistryObject<IERecipeSerializer<ThermoelectricSource>> SERIALIZER;
    public static Collection<ThermoelectricSource> ALL_SOURCES;
    public final FastEither<Tag<Block>, List<Block>> blocks;
    public final int temperature;

    public ThermoelectricSource(ResourceLocation id, Tag<Block> blocks, int temperature) {
        this(id, FastEither.left(blocks), temperature);
    }

    public ThermoelectricSource(ResourceLocation id, List<Block> blocks, int temperature) {
        this(id, FastEither.right(blocks), temperature);
    }

    private ThermoelectricSource(ResourceLocation id, FastEither<Tag<Block>, List<Block>> blocks, int temperature) {
        super(ItemStack.f_41583_, TYPE, id);
        this.blocks = blocks;
        this.temperature = temperature;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public Block getExample() {
        return this.blocks.map(t -> (Block)t.m_13288_(ApiUtils.RANDOM), l -> l.isEmpty() ? Blocks.f_50016_ : (Block)l.get(0));
    }

    public List<Block> getMatchingBlocks() {
        return this.blocks.map(Tag::m_6497_, Function.identity());
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean matches(Block block) {
        if (this.blocks.isLeft()) {
            return this.blocks.leftNonnull().m_8110_((Object)block);
        }
        return this.blocks.rightNonnull().contains(block);
    }

    @Nullable
    public static ThermoelectricSource getSource(Block block, @Nullable ThermoelectricSource hint) {
        if (hint != null && hint.matches(block)) {
            return hint;
        }
        for (ThermoelectricSource entry : ALL_SOURCES) {
            if (!entry.matches(block)) continue;
            return entry;
        }
        return null;
    }

    public static SortedMap<Component, Integer> getThermalValuesSorted(boolean inverse) {
        TreeMap<Component, Integer> existingMap = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, inverse ? Comparator.reverseOrder() : Comparator.naturalOrder()));
        for (ThermoelectricSource ingr : ALL_SOURCES) {
            Block example = ingr.getExample();
            if (example == Blocks.f_50016_) continue;
            existingMap.put(new ItemStack((ItemLike)example).m_41786_(), ingr.temperature);
        }
        return existingMap;
    }

    static {
        ALL_SOURCES = new ArrayList<ThermoelectricSource>();
    }
}

