/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.utils.FastEither;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegistryObject;

public class GeneratorFuel
extends IESerializableRecipe {
    public static RecipeType<GeneratorFuel> TYPE;
    public static RegistryObject<IERecipeSerializer<GeneratorFuel>> SERIALIZER;
    public static Collection<GeneratorFuel> ALL_FUELS;
    private final FastEither<Tag<Fluid>, List<Fluid>> fluids;
    private final int burnTime;

    public GeneratorFuel(ResourceLocation id, Tag<Fluid> fluids, int burnTime) {
        super(ItemStack.f_41583_, TYPE, id);
        this.fluids = FastEither.left(fluids);
        this.burnTime = burnTime;
    }

    public GeneratorFuel(ResourceLocation id, List<Fluid> fluids, int burnTime) {
        super(ItemStack.f_41583_, TYPE, id);
        this.fluids = FastEither.right(fluids);
        this.burnTime = burnTime;
    }

    public List<Fluid> getFluids() {
        return this.fluids.map(Tag::m_6497_, Function.identity());
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean matches(Fluid in) {
        if (this.fluids.isLeft()) {
            return in.m_76108_(this.fluids.leftNonnull());
        }
        return this.fluids.rightNonnull().contains(in);
    }

    public static GeneratorFuel getRecipeFor(Fluid in, @Nullable GeneratorFuel hint) {
        if (hint != null && hint.matches(in)) {
            return hint;
        }
        for (GeneratorFuel fuel : ALL_FUELS) {
            if (!fuel.matches(in)) continue;
            return fuel;
        }
        return null;
    }

    static {
        ALL_FUELS = new ArrayList<GeneratorFuel>();
    }
}

