/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class CrusherRecipeBuilder
extends IEFinishedRecipe<CrusherRecipeBuilder> {
    JsonArray secondaryArray = new JsonArray();

    private CrusherRecipeBuilder() {
        super((IERecipeSerializer)CrusherRecipe.SERIALIZER.get());
        this.addWriter(jsonObject -> jsonObject.add("secondaries", (JsonElement)this.secondaryArray));
    }

    public static CrusherRecipeBuilder builder(Item result) {
        return (CrusherRecipeBuilder)new CrusherRecipeBuilder().addResult((ItemLike)result);
    }

    public static CrusherRecipeBuilder builder(ItemStack result) {
        return (CrusherRecipeBuilder)new CrusherRecipeBuilder().addResult(result);
    }

    public static CrusherRecipeBuilder builder(Tag<Item> result, int count) {
        return (CrusherRecipeBuilder)new CrusherRecipeBuilder().addResult(new IngredientWithSize(result, count));
    }

    public static CrusherRecipeBuilder builder(IngredientWithSize result) {
        return (CrusherRecipeBuilder)new CrusherRecipeBuilder().addResult(result);
    }

    public CrusherRecipeBuilder addSecondary(ItemLike itemProvider, float chance) {
        return this.addSecondary(new ItemStack(itemProvider), chance);
    }

    public CrusherRecipeBuilder addSecondary(ItemStack itemStack, float chance) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", (JsonElement)this.serializeItemStack(itemStack));
        this.secondaryArray.add((JsonElement)jsonObject);
        return this;
    }

    public CrusherRecipeBuilder addSecondary(Tag<Item> tag, float chance) {
        return this.addSecondary(new IngredientWithSize(tag), chance, new ICondition[0]);
    }

    public CrusherRecipeBuilder addSecondary(IngredientWithSize ingredient, float chance, ICondition ... conditions) {
        this.secondaryArray.add((JsonElement)CrusherRecipeBuilder.serializeStackWithChance(ingredient, chance, conditions));
        return this;
    }
}

