/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.RegistryObject;

public class SawmillRecipe
extends MultiblockRecipe {
    public static RecipeType<SawmillRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<SawmillRecipe>> SERIALIZER;
    public final Ingredient input;
    public final ItemStack stripped;
    public final NonNullList<ItemStack> secondaryStripping = NonNullList.m_122779_();
    public final ItemStack output;
    public final NonNullList<ItemStack> secondaryOutputs = NonNullList.m_122779_();
    public static Map<ResourceLocation, SawmillRecipe> recipeList;

    public SawmillRecipe(ResourceLocation id, ItemStack output, ItemStack stripped, Ingredient input, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.stripped = stripped;
        this.input = input;
        this.setTimeAndEnergy(80, energy);
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{this.output});
    }

    protected IERecipeSerializer<SawmillRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs(BlockEntity tile) {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.stripped);
        for (ItemStack output : this.secondaryStripping) {
            if (output.m_41619_()) continue;
            list.add((Object)output);
        }
        list.add((Object)this.output);
        for (ItemStack output : this.secondaryOutputs) {
            if (output.m_41619_()) continue;
            list.add((Object)output);
        }
        return list;
    }

    public SawmillRecipe addToSecondaryStripping(ItemStack output) {
        Preconditions.checkNotNull((Object)output);
        this.secondaryStripping.add((Object)output);
        return this;
    }

    public SawmillRecipe addToSecondaryOutput(ItemStack output) {
        Preconditions.checkNotNull((Object)output);
        this.secondaryOutputs.add((Object)output);
        return this;
    }

    public static SawmillRecipe findRecipe(ItemStack input) {
        if (!input.m_41619_()) {
            for (SawmillRecipe recipe : recipeList.values()) {
                if (!recipe.input.test(input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

