/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class RefineryRecipe
extends MultiblockRecipe {
    public static RecipeType<RefineryRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<RefineryRecipe>> SERIALIZER;
    public final FluidStack output;
    public final FluidTagInput input0;
    public final FluidTagInput input1;
    public final Ingredient catalyst;
    public static Map<ResourceLocation, RefineryRecipe> recipeList;

    public RefineryRecipe(ResourceLocation id, FluidStack output, FluidTagInput input0, FluidTagInput input1, Ingredient catalyst, int energy) {
        super(ItemStack.f_41583_, TYPE, id);
        this.output = output;
        this.input0 = input0;
        this.input1 = input1;
        this.catalyst = catalyst;
        this.setTimeAndEnergy(1, energy);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.input0, this.input1});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    protected IERecipeSerializer<RefineryRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static RefineryRecipe findRecipe(FluidStack input0, FluidStack input1, ItemStack catalyst) {
        for (RefineryRecipe recipe : recipeList.values()) {
            if (!recipe.catalyst.test(catalyst)) continue;
            if (input0 != null) {
                if (recipe.input0 != null && recipe.input0.test(input0) && (recipe.input1 == null && input1 == null || recipe.input1 != null && input1 != null && recipe.input1.test(input1))) {
                    return recipe;
                }
                if (recipe.input1 == null || !recipe.input1.test(input0) || (recipe.input0 != null || input1 != null) && (recipe.input0 == null || input1 == null || !recipe.input0.test(input1))) continue;
                return recipe;
            }
            if (input1 == null) continue;
            if (recipe.input0 != null && recipe.input0.test(input1) && recipe.input1 == null) {
                return recipe;
            }
            if (recipe.input1 == null || !recipe.input1.test(input1) || recipe.input0 != null) continue;
            return recipe;
        }
        return null;
    }

    public static Optional<RefineryRecipe> findIncompleteRefineryRecipe(@Nonnull FluidStack input0, @Nonnull FluidStack input1) {
        if (input0.isEmpty() && input1.isEmpty()) {
            return Optional.empty();
        }
        for (RefineryRecipe recipe : recipeList.values()) {
            if (!(!input0.isEmpty() && input1.isEmpty() ? recipe.input0.testIgnoringAmount(input0) || recipe.input1.testIgnoringAmount(input0) : (input0.isEmpty() && !input1.isEmpty() ? recipe.input0.testIgnoringAmount(input1) || recipe.input1.testIgnoringAmount(input1) : recipe.input0.testIgnoringAmount(input0) && recipe.input1.testIgnoringAmount(input1) || recipe.input1.testIgnoringAmount(input0) && recipe.input0.testIgnoringAmount(input1)))) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

