/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class MetalPressRecipe
extends MultiblockRecipe {
    public static RecipeType<MetalPressRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<MetalPressRecipe>> SERIALIZER;
    public IngredientWithSize input;
    public final Item mold;
    public final ItemStack output;
    public static Map<ResourceLocation, MetalPressRecipe> recipeList;
    private static ArrayListMultimap<Item, MetalPressRecipe> recipesByMold;

    public MetalPressRecipe(ResourceLocation id, ItemStack output, IngredientWithSize input, Item mold, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.mold = mold;
        this.setTimeAndEnergy(60, energy);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.outputList = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{this.output});
    }

    protected IERecipeSerializer<MetalPressRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public MetalPressRecipe setInputSize(int size) {
        this.input = new IngredientWithSize(this.input.getBaseIngredient(), size);
        return this;
    }

    public boolean matches(ItemStack mold, ItemStack input, Level world) {
        return this.input.test(input);
    }

    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, Level world) {
        return this;
    }

    public static void updateRecipesByMold() {
        recipesByMold = ArrayListMultimap.create();
        recipeList.values().forEach(recipe -> recipesByMold.put((Object)recipe.mold, recipe));
    }

    public static MetalPressRecipe findRecipe(ItemStack mold, ItemStack input, Level world) {
        if (mold.m_41619_() || input.m_41619_()) {
            return null;
        }
        List list = recipesByMold.get((Object)mold.m_41720_());
        for (MetalPressRecipe recipe : list) {
            if (!recipe.matches(mold, input, world)) continue;
            return recipe.getActualRecipe(mold, input, world);
        }
        return null;
    }

    public static List<MetalPressRecipe> removeRecipes(ItemStack output) {
        ArrayList<MetalPressRecipe> list = new ArrayList<MetalPressRecipe>();
        HashSet keySet = new HashSet(recipesByMold.keySet());
        for (Item mold : keySet) {
            Iterator it = recipesByMold.get((Object)mold).iterator();
            while (it.hasNext()) {
                MetalPressRecipe ir = (MetalPressRecipe)it.next();
                if (!ItemStack.m_41746_((ItemStack)ir.output, (ItemStack)output)) continue;
                list.add(ir);
                it.remove();
            }
        }
        return list;
    }

    public static boolean isValidMold(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        return recipesByMold.containsKey((Object)itemStack.m_41720_());
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        recipeList = Collections.emptyMap();
        recipesByMold = ArrayListMultimap.create();
    }
}

