/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IIngredientWithSizeSerializer;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.gson.JsonElement;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.ItemHandlerHelper;

public class IngredientWithSize
implements Predicate<ItemStack> {
    public static final SetRestrictedField<IIngredientWithSizeSerializer> SERIALIZER = SetRestrictedField.common();
    protected final Ingredient basePredicate;
    protected final int count;

    public IngredientWithSize(Ingredient basePredicate, int count) {
        this.basePredicate = basePredicate;
        this.count = count;
    }

    public IngredientWithSize(Ingredient basePredicate) {
        this(basePredicate, 1);
    }

    public IngredientWithSize(Tag<Item> basePredicate, int count) {
        this(Ingredient.m_43911_(basePredicate), count);
    }

    public IngredientWithSize(Tag<Item> basePredicate) {
        this(basePredicate, 1);
    }

    public static IngredientWithSize deserialize(JsonElement input) {
        return SERIALIZER.getValue().parse(input);
    }

    public static IngredientWithSize read(FriendlyByteBuf input) {
        return SERIALIZER.getValue().parse(input);
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.basePredicate.test(itemStack) && itemStack.m_41613_() >= this.count;
    }

    @Nonnull
    public ItemStack[] getMatchingStacks() {
        ItemStack[] baseStacks = this.basePredicate.m_43908_();
        ItemStack[] ret = new ItemStack[baseStacks.length];
        for (int i = 0; i < baseStacks.length; ++i) {
            ret[i] = ItemHandlerHelper.copyStackWithSize((ItemStack)baseStacks[i], (int)this.count);
        }
        return ret;
    }

    @Nonnull
    public JsonElement serialize() {
        return SERIALIZER.getValue().write(this);
    }

    public boolean hasNoMatchingItems() {
        return this.basePredicate.m_43947_();
    }

    public int getCount() {
        return this.count;
    }

    public Ingredient getBaseIngredient() {
        return this.basePredicate;
    }

    public IngredientWithSize withSize(int size) {
        return new IngredientWithSize(this.basePredicate, size);
    }

    public static IngredientWithSize of(ItemStack stack) {
        return new IngredientWithSize(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_());
    }

    public ItemStack getRandomizedExampleStack(int rand) {
        ItemStack[] all = this.getMatchingStacks();
        if (all.length == 0) {
            return ItemStack.f_41583_;
        }
        return all[rand / 20 % all.length];
    }

    public boolean testIgnoringSize(ItemStack itemstack) {
        return this.basePredicate.test(itemstack);
    }

    public void write(FriendlyByteBuf out) {
        SERIALIZER.getValue().write(out, this);
    }
}

