/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class FermenterRecipe
extends MultiblockRecipe {
    public static RecipeType<FermenterRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<FermenterRecipe>> SERIALIZER;
    public IngredientWithSize input;
    public final FluidStack fluidOutput;
    @Nonnull
    public final ItemStack itemOutput;
    public static Map<ResourceLocation, FermenterRecipe> recipeList;

    public FermenterRecipe(ResourceLocation id, FluidStack fluidOutput, @Nonnull ItemStack itemOutput, IngredientWithSize input, int energy) {
        super(itemOutput, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = input;
        this.setTimeAndEnergy(80, energy);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{this.itemOutput});
    }

    protected IERecipeSerializer<FermenterRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public FermenterRecipe setInputSize(int size) {
        this.input = this.input.withSize(size);
        return this;
    }

    public static FermenterRecipe findRecipe(ItemStack input) {
        if (input.m_41619_()) {
            return null;
        }
        for (FermenterRecipe recipe : recipeList.values()) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public static SortedMap<Component, Integer> getFluidValuesSorted(Fluid f, boolean inverse) {
        TreeMap<Component, Integer> map = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, inverse ? Comparator.reverseOrder() : Comparator.naturalOrder()));
        for (FermenterRecipe recipe : recipeList.values()) {
            if (recipe.fluidOutput == null || recipe.fluidOutput.getFluid() != f || recipe.input.hasNoMatchingItems()) continue;
            ItemStack is = recipe.input.getMatchingStacks()[0];
            map.put(is.m_41786_(), recipe.fluidOutput.getAmount());
        }
        return map;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

