/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

public class ClocheRecipe
extends IESerializableRecipe {
    public static RecipeType<ClocheRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<ClocheRecipe>> SERIALIZER;
    public final List<ItemStack> outputs;
    public final Ingredient seed;
    public final Ingredient soil;
    public final int time;
    public final ClocheRenderFunction.ClocheRenderReference renderReference;
    public final ClocheRenderFunction renderFunction;
    public static Map<ResourceLocation, ClocheRecipe> recipeList;
    private static final List<Pair<Ingredient, ResourceLocation>> soilTextureList;

    public ClocheRecipe(ResourceLocation id, List<ItemStack> outputs, Ingredient seed, Ingredient soil, int time, ClocheRenderFunction.ClocheRenderReference renderReference) {
        super(outputs.get(0), TYPE, id);
        this.outputs = outputs;
        this.seed = seed;
        this.soil = soil;
        this.time = time;
        this.renderReference = renderReference;
        this.renderFunction = (ClocheRenderFunction)ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.get(renderReference.getType()).apply(renderReference.getBlock());
    }

    public ClocheRecipe(ResourceLocation id, ItemStack output, Ingredient seed, Ingredient soil, int time, ClocheRenderFunction.ClocheRenderReference renderReference) {
        this(id, (List<ItemStack>)ImmutableList.of((Object)output), seed, soil, time, renderReference);
    }

    public List<ItemStack> getOutputs(ItemStack seed, ItemStack soil) {
        return this.outputs;
    }

    public int getTime(ItemStack seed, ItemStack soil) {
        return this.time;
    }

    protected IERecipeSerializer<ClocheRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_() {
        return this.outputs.get(0);
    }

    public static ClocheRecipe findRecipe(ItemStack seed, ItemStack soil, @Nullable ClocheRecipe hint) {
        if (seed.m_41619_() || soil.m_41619_()) {
            return null;
        }
        if (hint != null && hint.matches(seed, soil)) {
            return hint;
        }
        for (ClocheRecipe recipe : recipeList.values()) {
            if (!recipe.matches(seed, soil)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(ItemStack seed, ItemStack soil) {
        return this.seed.test(seed) && this.soil.test(soil);
    }

    public static void registerSoilTexture(Ingredient soil, ResourceLocation texture) {
        soilTextureList.add((Pair<Ingredient, ResourceLocation>)Pair.of((Object)soil, (Object)texture));
    }

    public static ResourceLocation getSoilTexture(ItemStack soil) {
        for (Pair<Ingredient, ResourceLocation> entry : soilTextureList) {
            if (!((Ingredient)entry.getFirst()).test(soil)) continue;
            return (ResourceLocation)entry.getSecond();
        }
        return null;
    }

    static {
        recipeList = Collections.emptyMap();
        soilTextureList = new ArrayList<Pair<Ingredient, ResourceLocation>>();
    }
}

