/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import java.util.Collections;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

public class BlastFurnaceFuel
extends IESerializableRecipe {
    public static RecipeType<BlastFurnaceFuel> TYPE;
    public static RegistryObject<IERecipeSerializer<BlastFurnaceFuel>> SERIALIZER;
    public static Map<ResourceLocation, BlastFurnaceFuel> blastFuels;
    public final Ingredient input;
    public final int burnTime;

    public BlastFurnaceFuel(ResourceLocation id, Ingredient input, int burnTime) {
        super(ItemStack.f_41583_, TYPE, id);
        this.input = input;
        this.burnTime = burnTime;
    }

    public static int getBlastFuelTime(ItemStack stack) {
        for (BlastFurnaceFuel e : blastFuels.values()) {
            if (!e.input.test(stack)) continue;
            return e.burnTime;
        }
        return 0;
    }

    public static boolean isValidBlastFuel(ItemStack stack) {
        return BlastFurnaceFuel.getBlastFuelTime(stack) > 0;
    }

    protected IERecipeSerializer<BlastFurnaceFuel> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    static {
        blastFuels = Collections.emptyMap();
    }
}

